﻿using System;
using System.Reflection;
using System.Windows.Forms;

namespace WebSocketExample
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            AppDomain.CurrentDomain.AssemblyResolve += new ResolveEventHandler(CurrentDomain_AssemblyResolve);

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Form1());
        }



        private static Assembly CurrentDomain_AssemblyResolve(object sender, ResolveEventArgs args)
        {
            try
            {
                var a1 = Assembly.GetExecutingAssembly();

                var resourceName = new AssemblyName(args.Name).Name + ".dll";
                var manifestResourceNames = a1.GetManifestResourceNames();
                var resource = Array.Find(manifestResourceNames, element => element.EndsWith(resourceName));

                if (null != resource)
                {
                    using (var stream = a1.GetManifestResourceStream(resource))
                    {
                        var assemblyData = new byte[stream.Length];
                        stream.Read(assemblyData, 0, assemblyData.Length);
                        return Assembly.Load(assemblyData);
                    }
                }
                return null;
            }
            catch (Exception ex)
            {
                return null;
            }
        }
    }
}
