﻿// Compares two ListView items using all of their columns.
using System;
using System.Collections;
using System.Windows.Forms;

public class ListViewItemColumnComparer : IComparer
{
    private int _column;
    private SortOrder _sortOrder;


    public ListViewItemColumnComparer(int column, SortOrder sortOrder)
    {
        _column = column;
        _sortOrder = sortOrder;
    }



    // Compare two ListViewItems.
    public int Compare(object object_x, object object_y)
    {
        // Get the objects as ListViewItems.
        ListViewItem item_x = object_x as ListViewItem;
        ListViewItem item_y = object_y as ListViewItem;

        // If item_y is out of sub-items,
        // then it comes first.
        if (item_y.SubItems.Count <= _column)
            return 1;

        // Get the sub-items.
        string string_x = item_x.SubItems[_column].Text;
        string string_y = item_y.SubItems[_column].Text;

        // Compare them.
        int result = CompareValues(string_x, string_y);

        if (result != 0)
            return result;

        // If we get here, we have an exact match.
        return 0;
    }



    // Compare two items. If they look like
    // numbers or dates, compare them as such.
    private int CompareValues(string string_x, string string_y)
    {
        // Compare them.
        int result;
        double double_x, double_y;
        if (double.TryParse(string_x, out double_x) &&
            double.TryParse(string_y, out double_y))
        {
            // Treat as a number.
            result = double_x.CompareTo(double_y);
        }
        else
        {
            DateTime date_x, date_y;
            if (DateTime.TryParse(string_x, out date_x) &&
                DateTime.TryParse(string_y, out date_y))
            {
                // Treat as a date.
                result = date_x.CompareTo(date_y);
            }
            else
            {
                // Treat as a string.
                result = string_x.CompareTo(string_y);
            }
        }

        if (_sortOrder == SortOrder.Descending)
            // Invert the value returned by String.Compare.
            result *= -1;
        return result;
    }
}