/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integ.common.logging.AppLog;
import com.integpg.snmp.Config;
import com.integpg.snmp.PDUSender;
import com.integpg.snmp.SNMPStore;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPIpAddress;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPTrapPDU;
import com.integpg.snmp.objects.SNMPVarBindings;
import com.integpg.snmp.objects.SNMPVariablePair;
import java.net.InetAddress;
import java.net.SocketException;

public class TrapSender
extends PDUSender {
    public static final int SNMP_TRAP_PORT = 162;

    public TrapSender() throws SocketException {
        super(162);
    }

    public void sendTrap(SNMPObjectIdentifier oid, SNMPObject snmpObject, String communityName) {
        String trapHost = Config.getTrapHost();
        if (null != trapHost && !"0.0.0.0".equals(trapHost)) {
            this.sendTrap(oid, snmpObject, trapHost, communityName);
        }
    }

    public void sendTrap(SNMPObjectIdentifier oid, SNMPObject snmpObject, String host, String communityName) {
        this.sendTrap(oid, snmpObject, host, 162, communityName);
    }

    public void sendTrap(SNMPObjectIdentifier oid, SNMPObject snmpObject, String host, int port, String communityName) {
        try {
            InetAddress trapHostAddress = InetAddress.getByName(host);
            if (trapHostAddress != null) {
                SNMPVarBindings varBindList = new SNMPVarBindings();
                varBindList.addPair(new SNMPVariablePair(oid, snmpObject));
                SNMPTrapPDU pdu = new SNMPTrapPDU(oid, new SNMPIpAddress(InetAddress.getLocalHost().getHostAddress()), new SNMPInteger(6L), new SNMPInteger(0L), SNMPStore.SYSTEM_UPTIME, varBindList);
                this.send(trapHostAddress, port, communityName, pdu);
                System.out.println("trap sent to " + trapHostAddress);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error sending trap", ex);
        }
    }
}

