/*
 * Decompiled with CFR 0.152.
 */
package com.integ.slaveservice;

import com.integ.slaveservice.LocalSlaveService;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import java.util.ArrayList;

public abstract class SlaveService
implements Runnable {
    protected Logger _log;
    protected Thread _monitorThread = null;
    protected int _failedOutputMask = 0;
    protected String[] _failedOutputStrings = new String[16];
    protected int _usedOutputMask = 0;
    protected boolean _running = false;
    protected final ArrayList<Rule> _rules = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRule(int localIoType, int localIoChannel, int remoteIoType, int remoteIoChannel, boolean invert) {
        String localOrRemote = this instanceof LocalSlaveService ? "LOCAL" : "REMOTE";
        Rule rule = new Rule();
        rule.LocalIoType = localIoType;
        rule.LocalIoChannel = localIoChannel;
        rule.RemoteIoType = remoteIoType;
        rule.RemoteIoChannel = remoteIoChannel;
        rule.LocalOrRemote = localOrRemote;
        rule.Invert = invert;
        ArrayList<Rule> arrayList = this._rules;
        synchronized (arrayList) {
            AppLog.info(rule.toString());
            this._log.info(rule.toString());
            this._rules.add(rule);
            AppLog.info(this._rules.size() + " rules in " + this.toString());
            for (Rule rule2 : this._rules) {
                AppLog.info(String.format("  %s", rule2.toString()));
            }
        }
        if (!this.isRunning()) {
            this.monitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRule(int localIoType, int localIoChannel) {
        System.out.println("localIoType = " + localIoType);
        System.out.println("localIoChannel = " + localIoChannel);
        ArrayList<Rule> arrayList = this._rules;
        synchronized (arrayList) {
            for (int i = 0; i < this._rules.size(); ++i) {
                Rule rule = this._rules.get(i);
                System.out.println("rule.LocalIoType = " + rule.LocalIoType);
                System.out.println("rule.LocalIoChannel = " + rule.LocalIoChannel);
                if (rule.LocalIoType != localIoType || rule.LocalIoChannel != localIoChannel) continue;
                AppLog.info("remove rule: " + rule);
                this._rules.remove(i--);
                break;
            }
            AppLog.info(this._rules.size() + " rules in " + this.toString());
            for (Rule rule2 : this._rules) {
                AppLog.info(String.format("  %s", rule2.toString()));
            }
        }
    }

    public void setFailedCommOutputState(int channel, String failedCommString) {
        System.out.println("set failed comm state for " + channel + " to " + failedCommString);
        if (!"hold-last-state".equals(failedCommString)) {
            this._failedOutputMask |= 1 << channel - 1;
            if (channel <= this._failedOutputStrings.length) {
                this._failedOutputStrings[channel - 1] = failedCommString;
            }
        } else {
            this._failedOutputMask &= 0xFFFF ^ 1 << channel - 1;
        }
        System.out.println("_failedOutputMask: 0x" + Long.toHexString(this._failedOutputMask));
    }

    public boolean isRunning() {
        return this._running;
    }

    public void stop() {
        this._running = false;
    }

    protected void monitor() {
    }

    protected class Rule {
        static final int INPUT = 0;
        static final int OUTPUT = 1;
        int LocalIoType;
        int LocalIoChannel;
        int RemoteIoType;
        int RemoteIoChannel;
        String LocalOrRemote;
        boolean Invert;
        private String _cacheToString = null;

        protected Rule() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Rule rule = this;
            synchronized (rule) {
                if (null == this._cacheToString) {
                    this._cacheToString = String.format("local %s %d follows %s %s%s %d", 0 == this.LocalIoType ? "INPUT" : "OUTPUT", this.LocalIoChannel, this.LocalOrRemote, this.Invert ? "inverted " : "", 0 == this.RemoteIoType ? "INPUT" : "OUTPUT", this.RemoteIoChannel);
                }
                return this._cacheToString;
            }
        }
    }
}

