/*
 * Decompiled with CFR 0.152.
 */
package com.integ.modbusserver;

import com.integ.modbusserver.AssemblyInfo;
import com.integ.modbusserver.ModbusServer;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.utils.RegistryUtils;
import com.integpg.system.JANOS;

public class ModbusServerMain {
    public static void main(String[] args) {
        Application.init(new AssemblyInfo());
        try {
            long[] addresses = JANOS.getExternalDeviceList();
            for (int i = 0; i < addresses.length; ++i) {
                int type = (int)(addresses[i] & 0xFFL);
                String hexAddress = "0000" + Long.toHexString(addresses[i]).toUpperCase();
                hexAddress = hexAddress.substring(hexAddress.length() - 16);
                JANOS.setRegistryString((String)("OneWire/" + hexAddress + "/Type"), (String)Integer.toHexString(type));
            }
            RegistryUtils.getRegistryKey("AppData/ModbusServer/Debug/ElapsedTimeTrigger", 750);
            ModbusServer modbusServer = new ModbusServer();
            modbusServer.start();
            Application.enableApplicationWatchdog(0);
            Application.sleepForever();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

