/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integ.common.externalmodules.TempProbe;
import com.integpg.snmp.SNMPStore;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPOctetString;

public class ExternalTempToSnmp {
    private final TempProbe _externalModule;
    private final SNMPOctetString _tempCelsiusOctetString = new SNMPOctetString();
    private final SNMPOctetString _tempFahrenheitOctetString = new SNMPOctetString();

    public ExternalTempToSnmp(TempProbe externalModule, int moduleIndex) {
        this._externalModule = externalModule;
        this.update();
        int type = 40;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, (SNMPObject)new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, (SNMPObject)this._tempCelsiusOctetString);
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, (SNMPObject)this._tempFahrenheitOctetString);
    }

    public void update() {
        this._tempCelsiusOctetString.setValue(String.format("%.2f", this._externalModule.getCelsius()));
        this._tempFahrenheitOctetString.setValue(String.format("%.2f", this._externalModule.getFahrenheit()));
    }
}

