/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPObject;
import java.io.IOException;

public class SNMPInteger
extends SNMPObject {
    protected long _value;

    public SNMPInteger() {
    }

    public SNMPInteger(long value) {
        this._value = value;
        this._length = this.getLength(value);
    }

    @Override
    public int getTag() {
        return 2;
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public void decodeBER(SNMPCodec codec) throws IOException {
        super.decodeBER(codec);
        this.getValue(codec);
    }

    private void getValue(SNMPCodec codec) throws IOException {
        long value = 0L;
        for (int i = 0; i < this._length; ++i) {
            value <<= 8;
            value += (long)codec.read();
        }
        this._value = value;
    }

    private int getLength(long value) {
        int bytesNeeded = SNMPCodec.bytesNeededForValue(value);
        if (4 < bytesNeeded) {
            bytesNeeded = 4;
        }
        return bytesNeeded;
    }

    @Override
    public int getLength() {
        this._value = (Long)this.getValue();
        return this.getLength(this._value);
    }

    @Override
    public void encodeBER(SNMPCodec codec) throws IOException {
        long value = (Long)this.getValue();
        int length = this.getLength();
        super.encodeBER(codec);
        for (int i = length - 1; i >= 0; --i) {
            int b = (int)(value >> i * 8 & 0xFFL);
            codec.write(b);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this._value);
    }
}

