/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.text;

import com.integpg.system.ArrayUtils;
import com.integpg.system.Timebase;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class QuickDateFormat {
    private static final String DEFAULT_PATTERN = "MM/dd/yyyy HH:mm:ss.fff zzz";
    private static QuickDateFormat DEFAULT = null;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final String[] MONTH_NAME_STRINGS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final byte[][] AM_PM_STRING_BYTES = new byte[][]{"am".getBytes(), "pm".getBytes()};
    private final String _pattern;
    private final byte[] _dateStampBytes;
    private int _byteLength;
    private int _timezoneLength;
    int _weekOfYearPos = -1;
    int _monthPos = -1;
    int _monthNamePos = -1;
    int _dayPos = -1;
    int _2yearPos = -1;
    int _4yearPos = -1;
    int _hourPos = -1;
    int _hourOfDayPos = -1;
    int _minutePos = -1;
    int _secondPos = -1;
    int _millisPos = -1;
    int _timezonePos = -1;
    int _timezoneOffsetPos = -1;
    int _ampmPos = -1;
    private final byte[] _buf = new byte[8];
    private long _lastTimeRef = 0L;
    private long _nextHour = System.currentTimeMillis() - System.currentTimeMillis() % 3600000L;
    private long _nextMinute = 0L;

    public static QuickDateFormat getDefault() {
        if (null == DEFAULT) {
            DEFAULT = new QuickDateFormat(DEFAULT_PATTERN);
        }
        return DEFAULT;
    }

    public QuickDateFormat(String pattern) {
        this._pattern = pattern;
        this._dateStampBytes = new byte[pattern.length() + 10];
        ArrayUtils.arraycopy((Object)pattern.getBytes(), (int)0, (Object)this._dateStampBytes, (int)0, (int)pattern.length());
        this._weekOfYearPos = this.getIndexOf("WY");
        this._monthNamePos = this.getIndexOf("MMM");
        if (-1 == this._monthNamePos) {
            this._monthPos = this.getIndexOf("MM");
        }
        this._dayPos = this.getIndexOf("dd");
        if (-1 == this._dayPos) {
            this._dayPos = this.getIndexOf("DD");
        }
        this._2yearPos = this.getIndexOf("yy");
        if (-1 == this._2yearPos) {
            this._2yearPos = this.getIndexOf("YY");
        }
        this._4yearPos = this.getIndexOf("yyyy");
        if (-1 == this._4yearPos) {
            this._4yearPos = this.getIndexOf("YYYY");
        }
        this._hourPos = this.getIndexOf("hh");
        this._hourOfDayPos = this.getIndexOf("HH");
        this._minutePos = this.getIndexOf("mm");
        this._secondPos = this.getIndexOf("ss");
        this._millisPos = this.getIndexOf("fff");
        if (-1 == this._millisPos) {
            this._millisPos = this.getIndexOf("SSS");
        }
        this._ampmPos = this.getIndexOf("aa");
        this._timezonePos = this.getIndexOf("zzz", 4);
        this._timezoneOffsetPos = this.getIndexOf("Z", 5);
        this.updateTimezone();
    }

    private int getIndexOf(String searchPattern) {
        return this.getIndexOf(searchPattern, searchPattern.length());
    }

    private int getIndexOf(String searchPattern, int valueLength) {
        int indexOf = this._pattern.indexOf(searchPattern);
        if (indexOf + valueLength > this._byteLength) {
            this._byteLength = indexOf + valueLength;
        }
        return indexOf;
    }

    public String getDateFormatString() {
        return this._pattern;
    }

    public Date parse(String dateString) {
        Calendar cal = Calendar.getInstance();
        try {
            int month = -1;
            if (-1 != this._monthNamePos) {
                String monthString = dateString.substring(this._monthNamePos, this._monthNamePos + 3).toLowerCase();
                int monthIndex = "janfebmaraprmayjunjulaugsepoctnovdec".indexOf(monthString);
                month = monthIndex / 3;
            } else if (-1 != this._monthPos) {
                month = Integer.parseInt(dateString.substring(this._monthPos, this._monthPos + 2)) - 1;
            }
            int dayOfMonth = Integer.parseInt(dateString.substring(this._dayPos, this._dayPos + 2));
            int year = 0;
            if (-1 != this._4yearPos) {
                year = Integer.parseInt(dateString.substring(this._4yearPos, this._4yearPos + 4));
            } else if (-1 != this._2yearPos) {
                year = Integer.parseInt(dateString.substring(this._2yearPos, this._2yearPos + 2));
                year += 2000;
            }
            int hour = 0;
            if (-1 != this._hourOfDayPos) {
                hour = Integer.parseInt(dateString.substring(this._hourOfDayPos, this._hourOfDayPos + 2));
            } else if (-1 != this._hourPos) {
                hour = Integer.parseInt(dateString.substring(this._hourPos, this._hourPos + 2));
            }
            int minute = Integer.parseInt(dateString.substring(this._minutePos, this._minutePos + 2));
            int second = 0;
            if (-1 != this._secondPos) {
                second = Integer.parseInt(dateString.substring(this._secondPos, this._secondPos + 2));
            }
            cal.set(year, month, dayOfMonth, hour, minute, second);
            if (-1 != this._millisPos) {
                int millis = Integer.parseInt(dateString.substring(this._millisPos, this._millisPos + 3));
                cal.set(14, millis);
            }
        }
        catch (Exception ex) {
            System.err.println(String.format("error parsing date %s", dateString));
        }
        return cal.getTime();
    }

    private void updateTimezone() {
        if (-1 != this._timezonePos) {
            String dstString;
            String timezoneString = Timebase.getTimeZone();
            if (Timebase.isDST((long)System.currentTimeMillis(), (String)timezoneString) && null != (dstString = Timebase.getDSTTimeZone((String)timezoneString))) {
                timezoneString = dstString;
            }
            this._timezoneLength = timezoneString.length();
            ArrayUtils.arraycopy((Object)timezoneString.getBytes(), (int)0, (Object)this._dateStampBytes, (int)this._timezonePos, (int)this._timezoneLength);
        } else if (-1 != this._timezoneOffsetPos) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            long millisIntoDay = calendar.get(11) * 3600000 + calendar.get(12) * 60000 + calendar.get(13) * 1000;
            TimeZone timezone = calendar.getTimeZone();
            long timeZoneOffset = timezone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), (int)millisIntoDay);
            int hoursOffset = (int)(timeZoneOffset / 3600000L);
            int minutesOffset = (int)(timeZoneOffset % 3600000L) / 60000;
            String timezoneOffsetString = 0 < hoursOffset ? "+" : "-";
            timezoneOffsetString = timezoneOffsetString + String.format("%02d%02d", Math.abs(hoursOffset), minutesOffset);
            ArrayUtils.arraycopy((Object)timezoneOffsetString.getBytes(), (int)0, (Object)this._dateStampBytes, (int)this._timezoneOffsetPos, (int)5);
        }
    }

    public String format(Date date) {
        return this.format(date.getTime());
    }

    public String format() {
        return this.format(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(long time) {
        byte[] byArray = this._dateStampBytes;
        synchronized (this._dateStampBytes) {
            if (time <= 0L) {
                time = System.currentTimeMillis();
            }
            if (this._nextHour <= time) {
                this._nextHour += 3600000L;
                this.updateTimezone();
            }
            if (this._lastTimeRef > time || time >= this._nextMinute) {
                this.initRefBytes(time);
            }
            int delta = (int)(time - this._lastTimeRef);
            int rSecond = delta / 1000;
            if (-1 != this._secondPos) {
                this.stuffInt(this._buf, rSecond + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._secondPos, (int)2);
            }
            if (-1 != this._millisPos) {
                int rMillis = delta - 1000 * rSecond;
                this.stuffInt(this._buf, rMillis + 1000, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._millisPos, (int)3);
            }
            int firstNullPos = this._dateStampBytes.length;
            for (int i = 0; i < firstNullPos; ++i) {
                if (this._dateStampBytes[i] != 0) continue;
                firstNullPos = i;
                break;
            }
            String result = new String(this._dateStampBytes, 0, firstNullPos);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return result;
        }
    }

    public byte[] toByteArray() {
        return this._dateStampBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRefBytes(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int second = calendar.get(13);
        int millis = calendar.get(14);
        this._lastTimeRef = time - (long)(1000 * second + millis);
        this._nextMinute = time + 60000L - time % 60000L;
        byte[] byArray = this._dateStampBytes;
        synchronized (this._dateStampBytes) {
            int rHour;
            int month;
            if (-1 != this._weekOfYearPos) {
                int weekOfYear = calendar.get(3);
                this.stuffInt(this._buf, weekOfYear + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._weekOfYearPos, (int)2);
            }
            if (-1 != this._monthPos) {
                month = calendar.get(2);
                this.stuffInt(this._buf, month + 101, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._monthPos, (int)2);
            }
            if (-1 != this._monthNamePos) {
                month = calendar.get(2);
                String monthName = MONTH_NAME_STRINGS[month];
                ArrayUtils.arraycopy((Object)monthName.getBytes(), (int)0, (Object)this._dateStampBytes, (int)this._monthNamePos, (int)3);
            }
            if (-1 != this._dayPos) {
                int day = calendar.get(5);
                this.stuffInt(this._buf, day + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._dayPos, (int)2);
            }
            if (-1 != this._2yearPos || -1 != this._4yearPos) {
                int year = calendar.get(1);
                this.stuffInt(this._buf, year, 0, false);
                if (-1 != this._2yearPos) {
                    ArrayUtils.arraycopy((Object)this._buf, (int)2, (Object)this._dateStampBytes, (int)this._2yearPos, (int)2);
                }
                if (-1 != this._4yearPos) {
                    ArrayUtils.arraycopy((Object)this._buf, (int)0, (Object)this._dateStampBytes, (int)this._4yearPos, (int)4);
                }
            }
            if (-1 != this._hourPos) {
                rHour = calendar.get(10);
                this.stuffInt(this._buf, rHour + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._hourPos, (int)2);
            }
            if (-1 != this._hourOfDayPos) {
                rHour = calendar.get(11);
                this.stuffInt(this._buf, rHour + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._hourOfDayPos, (int)2);
            }
            if (-1 != this._minutePos) {
                int minute = calendar.get(12);
                this.stuffInt(this._buf, minute + 100, 0, false);
                ArrayUtils.arraycopy((Object)this._buf, (int)1, (Object)this._dateStampBytes, (int)this._minutePos, (int)2);
            }
            if (-1 != this._ampmPos) {
                byte[] amPmBytes = AM_PM_STRING_BYTES[calendar.get(9)];
                ArrayUtils.arraycopy((Object)amPmBytes, (int)0, (Object)this._dateStampBytes, (int)this._ampmPos, (int)2);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    private void stuffInt(byte[] array, int value, int dec, boolean rjustified) {
        int dig;
        ArrayUtils.arrayFill((byte[])array, (int)0, (int)array.length, (byte)32);
        if (value == 0) {
            array[0] = 48;
            return;
        }
        int offset = 0;
        boolean leading = true;
        if (value < 0) {
            array[offset++] = 45;
            value = -value;
            rjustified = false;
        }
        for (dig = 1000000; dig >= 1; dig /= 10) {
            if (leading && value < dig) {
                if (!rjustified) continue;
                ++offset;
                continue;
            }
            array[offset] = 48;
            while (value >= dig) {
                int n = offset;
                array[n] = (byte)(array[n] + 1);
                value -= dig;
            }
            ++offset;
            leading = false;
        }
        for (dig = dec; dig > 0; --dig) {
            array[offset] = array[offset - 1];
            if (array[offset] == 32) {
                array[offset] = 48;
            }
            --offset;
            if (dig != 1) continue;
            array[offset] = 46;
            if (array[offset - 1] != 32) continue;
            array[offset - 1] = 48;
        }
    }
}

