/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.JanosLib;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.system.AssemblyInfoBase;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.JDateFormat;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.ApplicationUtils;
import com.integpg.janoslib.utils.ExceptionUtils;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.system.JANOS;
import com.integpg.system.Watchdog;
import java.io.File;
import java.io.IOException;

public abstract class JanosApplication {
    public static long ApplicationStart = System.currentTimeMillis();
    private static final JDateFormat DATE_FORMAT = new JDateFormat().includeMilliseconds(true);
    private static String _registryRoot = "";
    private static boolean _isBackground = false;
    private static JanosApplication _janosApplication;
    private AssemblyInfoBase _assemblyInfo;
    private Watchdog _watchdog;

    protected JanosApplication() {
    }

    public abstract boolean shouldPreventDuplicateInstance();

    public final void configureWatchdog() {
        JanosApplication janosApplication = this;
        this._watchdog = new Watchdog(janosApplication._assemblyInfo.getName());
    }

    public abstract void init(String[] var1);

    public abstract void run() throws InterruptedException;

    public static void exec(JanosApplication janosApplication, AssemblyInfoBase assemblyInfo, String[] args) {
        if (1 == args.length && "--version".equals(args[0])) {
            Object[] objectArray = new Object[5];
            objectArray[0] = assemblyInfo.getName();
            objectArray[1] = assemblyInfo.getVersion();
            objectArray[2] = assemblyInfo.getBuildTime();
            objectArray[3] = JanosLib.getVersion();
            objectArray[4] = JanosLib.getBuildTime();
            String versionString = String.format("%s v%s (built %s)\nusing JanosLib v%s (built %s)", objectArray);
            System.out.println(versionString);
            System.exit(0);
        }
        try {
            boolean isForeground;
            _janosApplication = janosApplication;
            janosApplication._assemblyInfo = assemblyInfo;
            Object[] objectArray = new Object[1];
            objectArray[0] = assemblyInfo.getName();
            _registryRoot = String.format("AppData/%s/", objectArray);
            AppLog.init(assemblyInfo.getName());
            JanosApplication janosApplication2 = janosApplication;
            JANOS.setRegistryString((String)(_registryRoot + "$Name"), (String)janosApplication2._assemblyInfo.getName());
            JanosApplication janosApplication3 = janosApplication;
            JANOS.setRegistryString((String)(_registryRoot + "$Version"), (String)janosApplication3._assemblyInfo.getVersion());
            JanosApplication janosApplication4 = janosApplication;
            JANOS.setRegistryString((String)(_registryRoot + "$BuildTime"), (String)janosApplication4._assemblyInfo.getBuildTime());
            JANOS.setRegistryString((String)(_registryRoot + "$JanosLibVersion"), (String)JanosLib.getVersion());
            JANOS.setRegistryString((String)(_registryRoot + "$JanosLibBuildTime"), (String)JanosLib.getBuildTime());
            JANOS.setRegistryString((String)(_registryRoot + "$ExecutionTime"), (String)String.valueOf(System.currentTimeMillis()));
            JANOS.setRegistryString((String)(_registryRoot + "$pid"), (String)String.valueOf(JANOS.getProcessID()));
            _isBackground = ApplicationUtils.isBackground();
            janosApplication.logBanner();
            boolean bl = isForeground = !_isBackground;
            if (isForeground) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            JanosApplication janosApplication5 = janosApplication;
            int runningInstances = JANOS.registerProcess((String)janosApplication5._assemblyInfo.getName());
            if (janosApplication.shouldPreventDuplicateInstance() && 1 < runningInstances) {
                JanosApplication janosApplication6 = janosApplication;
                AppLog.error("another instance of " + janosApplication6._assemblyInfo.getName() + " is running");
                System.exit(-1);
            }
            janosApplication.configureWatchdog();
            janosApplication.init(args);
            double elapsedSeconds = (double)(System.currentTimeMillis() - ApplicationStart) / 1000.0;
            AppLog.info(String.format("Application Loaded in %.3f", elapsedSeconds));
            janosApplication.start();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            JanosApplication.fatal(ex);
        }
    }

    private void logBanner() {
        Object[] objectArray = new Object[6];
        JanosApplication janosApplication = this;
        objectArray[0] = janosApplication._assemblyInfo.getName();
        JanosApplication janosApplication2 = this;
        objectArray[1] = janosApplication2._assemblyInfo.getVersion();
        JanosApplication janosApplication3 = this;
        objectArray[2] = janosApplication3._assemblyInfo.getBuildTime();
        objectArray[3] = JanosLib.getVersion();
        objectArray[4] = JanosLib.getBuildTime();
        objectArray[5] = JANOS.getVersion();
        String versionString = String.format("%s v%s (built %s) using JanosLib v%s (built %s) running on JANOS %s", objectArray);
        JANOS.syslog((String)versionString);
        AppLog.vital(versionString);
        Object[] objectArray2 = new Object[4];
        JanosApplication janosApplication4 = this;
        objectArray2[0] = janosApplication4._assemblyInfo.getName();
        objectArray2[1] = JANOS.getProcessID();
        objectArray2[2] = UnitConfig.SERIAL_NUMBER;
        objectArray2[3] = UnitConfig.MODEL;
        AppLog.info(String.format("  %s[%d] running on S/N: %d, Model: %s", objectArray2));
        this.updateBootLog(versionString);
    }

    private void updateBootLog(String versionString) {
        try {
            String entry = String.format("%s, %s\r\n", DATE_FORMAT.format(System.currentTimeMillis()), versionString);
            JanosApplication janosApplication = this;
            File bootlogFile = new File(janosApplication._assemblyInfo.getName().toLowerCase() + "_boot.log");
            if (16384L < bootlogFile.length() + (long)entry.length()) {
                File bakFile = new File(bootlogFile.getPath() + ".bak");
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                bootlogFile.renameTo(bakFile);
            }
            FileUtils.appendAllBytes(bootlogFile.getPath(), entry.getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void start() {
        try {
            this._watchdog.activate();
            this.run();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            JanosApplication.fatal(ex);
        }
    }

    protected void feedWatchdog() {
        this._watchdog.refresh();
    }

    public void sleepForever() {
        try {
            AppLog.info("sleep forever...");
            while (true) {
                this._watchdog.refresh();
                Thread.sleep(this._watchdog.getDuration() / 2);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
    }

    protected void exit(int code) {
        if (null != this._watchdog) {
            this._watchdog.deactivate();
        }
        System.exit(code);
    }

    public static void fatal(Object object) {
        JanosApplication.fatal(new RuntimeException(object.toString()));
    }

    public static void fatal(Exception ex) {
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        System.err.println(String.format("%s: %s", QuickDateFormat.getDefault().format(), stackTrace));
        System.exit(-1);
    }
}

