/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPSequence;
import java.io.IOException;

public class SNMPVariablePair
extends SNMPSequence
implements Comparable {
    private SNMPObjectIdentifier _oid;
    private SNMPObject _snmpObject;

    public SNMPVariablePair() {
    }

    public SNMPVariablePair(SNMPObjectIdentifier oid, SNMPObject snmpObject) {
        this._oid = oid;
        this._snmpObject = snmpObject;
    }

    public SNMPObjectIdentifier getOID() {
        return this._oid;
    }

    public void setObject(SNMPObject snmpObject) {
        this._snmpObject = snmpObject;
    }

    public SNMPObject getObject() {
        return this._snmpObject;
    }

    @Override
    public void decodeBER(SNMPCodec codec) throws IOException {
        super.decodeBER(codec);
        this._oid = (SNMPObjectIdentifier)codec.getNextSnmpObject();
        this._snmpObject = codec.getNextSnmpObject();
    }

    @Override
    public void encodeBER(SNMPCodec codec) throws IOException {
        super.encodeBER(codec);
        this._oid.encodeBER(codec);
        this._snmpObject.encodeBER(codec);
    }

    @Override
    public int getLength() {
        this._length = this._oid.getTLVLength() + this._snmpObject.getTLVLength();
        return this._length;
    }

    @Override
    public String toString() {
        return "var binding: " + this._oid + " = " + this._snmpObject + "\r\n";
    }

    public int compareTo(Object o) {
        SNMPVariablePair pair = (SNMPVariablePair)o;
        return this._oid.compareTo(pair.getOID());
    }
}

