App.controller('serialToEthernetController', ['$scope', function ($scope) {

    var _this = this;
    _this.running = false;

    jnrwebsocket.addOnLoggedInListener(function onLoggedIn() {
        _this.config = {
            serialToEthernetSettings: {
                "maintainConnection": "", tcpPort: 9201, serialPort: "none", /**useRTSLine: "",*/
                hostAddress: 0
            }
        };
        _this.savedConfig;
        _this.Version;
        jnrwebsocket.subscribeRegistryKey('Run/SerialEthernet', function (registryKey, registryValue) {
            if (registryValue == "flash/serialethernet.jar") {
                _this.running = true;
            }
            if (registryValue == "") {
                _this.running = false;
            }
        });
        jnrwebsocket.readRegistryKey('AppData/SerialToEthernet/$Version', function (registryKey, registryValue) {
            _this.Version = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/SerialToEthernet/MaintainConnection', function (registryKey, registryValue) {
            if (registryValue == "true") {
                _this.config.serialToEthernetSettings.maintainConnection = 1;
            }
            if (registryValue == "false") {
                _this.config.serialToEthernetSettings.maintainConnection = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/SerialToEthernet/TcpPort', function (registryKey, registryValue) {
            _this.config.serialToEthernetSettings.tcpPort = parseInt(registryValue);
        });
        jnrwebsocket.readRegistryKey('AppData/SerialToEthernet/SerialPort', function (registryKey, registryValue) {
            if (registryValue == "AUX") {
                _this.config.serialToEthernetSettings.serialPort = "AUX";
            }
            if (registryValue == "COM") {
                _this.config.serialToEthernetSettings.serialPort = "COM";
            }
            if (registryValue == "none") {
                _this.config.serialToEthernetSettings.serialPort = "none";
            }
        });
        /**jnrwebsocket.readRegistryKey('AppData/SerialToEthernet/UseRTSLine', function (registryKey, registryValue) {
            if (registryValue == "true") {
                _this.config.serialToEthernetSettings.useRTSLine = 1;
            }
            if (registryValue == "false") {
                _this.config.serialToEthernetSettings.useRTSLine = 2
            }
        });*/
        jnrwebsocket.readRegistryKey('AppData/SerialToEthernet/HostAddress', function (registryKey, registryValue) {
            _this.config.serialToEthernetSettings.hostAddress = registryValue;
            _this.savedConfig = angular.copy(_this.config);
            $scope.$apply();
        });

    });

    _this.hasChanged = function (config, savedConfig) {
        var hasChanged = !angular.equals(config, savedConfig);
        return hasChanged;
    };

    _this.writingRegistry = function () {
        if (_this.config.serialToEthernetSettings.maintainConnection == 1) {
            jnrwebsocket.registryWrite('AppData/SerialToEthernet/MaintainConnection', true)
        }
        if (_this.config.serialToEthernetSettings.maintainConnection == 2) {
            jnrwebsocket.registryWrite('AppData/SerialToEthernet/MaintainConnection', false)
        }
        jnrwebsocket.registryWrite('AppData/SerialToEthernet/TcpPort', _this.config.serialToEthernetSettings.tcpPort)
        if (_this.config.serialToEthernetSettings.serialPort == "AUX") {
            jnrwebsocket.registryWrite('AppData/SerialToEthernet/SerialPort', "AUX")
        }
        if (_this.config.serialToEthernetSettings.serialPort == "COM") {
            jnrwebsocket.registryWrite('AppData/SerialToEthernet/SerialPort', "COM")
        }
        if (_this.config.serialToEthernetSettings.serialPort == "none") {
            jnrwebsocket.registryWrite('AppData/SerialToEthernet/SerialPort', "none")
        }
        /** if (_this.config.serialToEthernetSettings.useRTSLine == 1) {
            jnrwebsocket.registryWrite('AppData/SerialToEthernet/UseRTSLine', true)
        }
        if (_this.config.serialToEthernetSettings.useRTSLine == 2) {
            jnrwebsocket.registryWrite('AppData/SerialToEthernet/UseRTSLine', false)
        } */
        jnrwebsocket.registryWrite('AppData/SerialToEthernet/HostAddress', _this.config.serialToEthernetSettings.hostAddress)
        _this.savedConfig = angular.copy(_this.config);
        alert("Configuration Saved. A reboot may be needed for some changes to take affect.");
    }

}]);