/*
 * Decompiled with CFR 0.152.
 */
package com.integ.slaveservice;

import com.integ.slaveservice.JniorProtocolConnectionListener;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.Debug;
import com.integpg.system.JANOS;
import com.integpg.system.Security;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.EventObject;
import java.util.Vector;

public class JniorProtocolConnection
implements Runnable {
    private static final int LOGIN_REQUEST = 126;
    private static final int KEEP_ALIVE_INTERVAL = 30000;
    private final Vector _listeners = new Vector();
    private Thread _thread;
    private String _ipAddress;
    private int _port = 9200;
    private String _username = "jnior";
    private String _password = "jnior";
    private boolean _shutdown = false;
    private Socket _socket = null;
    private DataInputStream _in = null;
    private DataOutputStream _out = null;
    private String _connectionInfo = "";
    private boolean _connected = false;
    private boolean _goodConnection = false;
    private boolean _hasExtendedMonitorPacket = false;
    private String _model;
    private String _version;
    private int _inputCount;
    private int _outputCount;
    private int _inputs;
    private int _outputs;
    private long _time;
    private String _name = "<unknown>";
    private Logger _log = Logger.getLogger();
    private long _lastKeepAlive;
    private boolean _connectFailed = false;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setIpAddress(String ipAddress) {
        this._ipAddress = ipAddress;
    }

    public void setLog(Logger log) {
        this._log = log;
    }

    public Logger getLog() {
        return this._log;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }

    public boolean getConnectionState() {
        return this._goodConnection;
    }

    public void addConnectionListener(JniorProtocolConnectionListener listener) {
        this._listeners.addElement(listener);
    }

    public String getModel() {
        return this._model;
    }

    public String getVersion() {
        return this._version;
    }

    public int getInputCount() {
        return this._inputCount;
    }

    public int getOutputCount() {
        return this._outputCount;
    }

    private void alertConnectionAttempt() {
        this._log.info(String.format("trying to connect to %s", this._connectionInfo));
        for (int i = 0; i < this._listeners.size(); ++i) {
            JniorProtocolConnectionListener jcl = (JniorProtocolConnectionListener)this._listeners.elementAt(i);
            jcl.connectionAttempt(new EventObject(this));
        }
    }

    private void alertConnectionEstablished() {
        this._connected = true;
        this._log.info(String.format("established connection to %s", this._connectionInfo));
        for (int i = 0; i < this._listeners.size(); ++i) {
            JniorProtocolConnectionListener jcl = (JniorProtocolConnectionListener)this._listeners.elementAt(i);
            jcl.connectionEstablished(new EventObject(this));
        }
    }

    private void alertConnectionLost() {
        if (this._connected) {
            this._connected = false;
            this._log.warn(String.format("lost connection from %s", this._connectionInfo));
            for (int i = 0; i < this._listeners.size(); ++i) {
                JniorProtocolConnectionListener jcl = (JniorProtocolConnectionListener)this._listeners.elementAt(i);
                jcl.connectionLost(new EventObject(this));
            }
        }
    }

    public int getInputStates() {
        return this._inputs;
    }

    public int getOutputStates() {
        return this._outputs;
    }

    public long getTime() {
        return this._time;
    }

    public void start() {
        if (null == this._thread) {
            this._thread = new Thread(this);
            this._thread.setDaemon(true);
            this._thread.setName(String.format("%s:%s", this.getClass().getName(), this.getName()));
            this._thread.start();
        }
    }

    @Override
    public void run() {
        block14: while (!this._shutdown) {
            try {
                if (null != this._ipAddress && !"0.0.0.0".equals(this._ipAddress)) {
                    if (0 == this._port) {
                        this._port = 9200;
                    }
                    this._connectionInfo = this._ipAddress + ":" + this._port;
                    this.alertConnectionAttempt();
                    this._socket = new Socket(InetAddress.getByName(this._ipAddress), this._port);
                    this._socket.setSoTimeout(10000);
                    this._connectFailed = false;
                    this._connectionInfo = this._ipAddress + ":" + this._port + " using local " + this._socket.getLocalPort();
                    this.alertConnectionEstablished();
                    this._in = new DataInputStream(this._socket.getInputStream());
                    this._out = new DataOutputStream(new BufferedOutputStream(this._socket.getOutputStream(), 4096));
                    this.sendLogin();
                    while (!this._shutdown) {
                        while (!this._shutdown) {
                            try {
                                while (this._in.readByte() != 1) {
                                }
                                break;
                            }
                            catch (SocketTimeoutException ex) {
                                this._lastKeepAlive = System.currentTimeMillis();
                                this._log.info("Send keep-alive");
                                this._out.writeByte(6);
                                this._out.flush();
                            }
                            catch (InterruptedIOException iioe) {
                                throw new EOFException();
                            }
                        }
                        if (this._shutdown) {
                            this._log.info("shutdown");
                            continue block14;
                        }
                        byte[] msg = this.getMsg();
                        if (msg == null || msg.length == 0) {
                            this.close();
                            continue;
                        }
                        this._goodConnection = true;
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(msg));
                        byte msgType = in.readByte();
                        this._log.info(this._name + "   MsgType: " + msgType + "\r\n" + HexUtils.hexDump(msg, 0, msg.length));
                        switch (msgType) {
                            case 1: {
                                this.parseMonitor(in);
                                break;
                            }
                            case 2: {
                                this.parseExtendedMonitor(in);
                                break;
                            }
                            case 125: {
                                this.parseLoginResponse(in);
                                break;
                            }
                        }
                    }
                    continue;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                }
            }
            catch (Exception ex) {
                this._connectFailed = true;
                AppLog.error(ex);
                this.close();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this._log.error(this._name + " connection ended!");
    }

    private void parseMonitor(DataInputStream in) throws IOException {
        byte state;
        int n;
        int inputs = 0;
        int outputs = 0;
        String modelAndVersion = this.readString(in);
        if (null == this._model) {
            this._model = modelAndVersion.substring(0, modelAndVersion.indexOf(" "));
            System.out.println("model: " + this._model);
            int n2 = this._model.startsWith("412") ? 4 : (this._inputCount = this._model.startsWith("414") ? 12 : 8);
            this._outputCount = this._model.startsWith("412") ? 12 : (this._model.startsWith("414") ? 4 : 8);
            this._version = modelAndVersion.substring(modelAndVersion.indexOf(" ") + 1);
            this._hasExtendedMonitorPacket = 8 < this._inputCount || 8 < this._outputCount;
        }
        for (n = 0; n < 8; ++n) {
            state = in.readByte();
            inputs |= state << n;
            in.skip(7L);
        }
        this._inputs = inputs;
        for (n = 0; n < 8; ++n) {
            state = in.readByte();
            outputs |= state << n;
        }
        this._outputs = outputs;
        this._time = in.readLong();
        if (!this._hasExtendedMonitorPacket) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                JniorProtocolConnectionListener jcl = (JniorProtocolConnectionListener)this._listeners.elementAt(i);
                jcl.monitorReceived(new EventObject(this));
            }
        }
    }

    private void parseExtendedMonitor(DataInputStream in) throws IOException {
        byte state;
        int inputs = this._inputs;
        int outputs = this._outputs;
        int inputCount = in.readByte();
        for (int n = 0; n < inputCount; ++n) {
            int channel = n + 8;
            state = in.readByte();
            inputs |= state << channel;
            in.skipBytes(7);
        }
        this._inputs = inputs;
        int outputCount = in.readByte();
        for (int n = 0; n < outputCount; ++n) {
            state = in.readByte();
            outputs |= state << n + 8;
        }
        this._outputs = outputs;
        long time = in.readLong();
        for (int i = 0; i < this._listeners.size(); ++i) {
            JniorProtocolConnectionListener jcl = (JniorProtocolConnectionListener)this._listeners.elementAt(i);
            jcl.monitorReceived(new EventObject(this));
        }
    }

    private void parseLoginResponse(DataInputStream in) throws IOException, InterruptedException {
        this._log.info(this._name + " login " + this._ipAddress + ":" + this._port);
        byte level = in.readByte();
        this._log.info(this._name + " login level: " + level);
        if (-1 == level) {
            this._log.info(this._name + " bad login");
            Thread.sleep(10000L);
            this.close();
        }
    }

    private String readString(DataInputStream in) throws IOException {
        byte[] bData = new byte[in.readByte() & 0xFF];
        in.read(bData);
        return new String(bData);
    }

    private void writeString(String str, DataOutputStream out) throws IOException {
        if (str.length() < 255) {
            out.writeByte(str.length());
            out.writeBytes(str);
        } else {
            out.writeByte(255);
            out.writeBytes(str.substring(0, 255));
        }
    }

    private byte[] getMsg() throws IOException {
        short len = this._in.readShort();
        System.out.println("len = " + len);
        int crc = this._in.readShort() & 0xFFFF;
        System.out.println("crc = " + crc);
        if (0 <= len && 1024 > len) {
            byte[] data = new byte[len];
            this._in.read(data);
            Debug.dump((byte[])data);
            int calculatedCrc = JANOS.CRC16((byte[])data, (int)0, (int)len, (int)0);
            System.out.println("calculatedCrc = " + calculatedCrc);
            if (crc != calculatedCrc) {
                this._log.error(this._name + " CRC does not match");
                return null;
            }
            return data;
        }
        this._log.error(this._name + " message length out of bounds: " + len);
        return null;
    }

    private void sendMsg(byte[] message) throws IOException {
        if (message == null) {
            return;
        }
        this._out.writeByte(1);
        this._out.writeShort(message.length);
        this._out.writeShort(JANOS.CRC16((byte[])message, (int)0, (int)message.length, (int)0));
        this._out.write(message);
        this._out.flush();
    }

    public void close() {
        try {
            if (this._socket != null) {
                if (this._in != null) {
                    this._in.close();
                }
                if (this._out != null) {
                    this._out.close();
                }
                this._socket.close();
                this.alertConnectionLost();
            }
        }
        catch (IOException ex) {
            this._log.error(ex);
        }
        this._goodConnection = false;
        this._connectionInfo = "";
    }

    private void sendLogin() {
        try {
            ByteArrayOutputStream dataBytes = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(dataBytes);
            dataOut.writeByte(126);
            dataOut.writeByte(0);
            String combinedUserPassString = String.format("%s:%s", this._username, this._password);
            byte[] combinedUserPassBytes = combinedUserPassString.getBytes();
            byte[] base64EncodedBytes = Security.b64encode((byte[])combinedUserPassBytes, (int)0, (int)combinedUserPassBytes.length);
            dataOut.writeByte(base64EncodedBytes.length);
            dataOut.write(base64EncodedBytes);
            this.sendMsg(dataBytes.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException("error sending the login", ex);
        }
    }
}

