/*
 * Decompiled with CFR 0.152.
 */
package com.integ.serialtoethernet;

import com.integ.serialtoethernet.AssemblyInfo;
import com.integpg.janoslib.utils.RegistryUtils;
import com.integpg.system.JANOS;

public class Config {
    private static final String APPDATA_ROOT = "AppData/" + AssemblyInfo.getName();

    static void init() {
        RegistryUtils.moveFolder("AppData/TCP_to_Serial", APPDATA_ROOT);
        JANOS.setRegistryString((String)String.format("%s/Baudrate", APPDATA_ROOT), (String)"");
        JANOS.setRegistryString((String)String.format("%s/Databits", APPDATA_ROOT), (String)"");
        JANOS.setRegistryString((String)String.format("%s/Stopbits", APPDATA_ROOT), (String)"");
        JANOS.setRegistryString((String)String.format("%s/Parity", APPDATA_ROOT), (String)"");
        Config.getSerialPortName();
        Config.getTcpServerPort();
        Config.shouldMaintainConnection();
        Config.useRTSLine();
    }

    public static String getSerialPortName() {
        String serialPortName = RegistryUtils.getRegistryKey(String.format("%s/SerialPort", APPDATA_ROOT), "AUX");
        if ("rs232".equalsIgnoreCase(serialPortName)) {
            serialPortName = "COM";
        }
        return serialPortName;
    }

    public static int getTcpServerPort() {
        String oldKey = String.format("%s/Port", APPDATA_ROOT);
        String oldKeyValue = JANOS.getRegistryString((String)oldKey, (String)"");
        if (!"".equals(oldKeyValue)) {
            String newKey = String.format("%s/TcpPort", APPDATA_ROOT);
            JANOS.setRegistryString((String)newKey, (String)oldKeyValue);
        }
        return RegistryUtils.getRegistryKey(String.format("%s/TcpPort", APPDATA_ROOT), 9201);
    }

    public static String getHostAddress() {
        return RegistryUtils.getRegistryKey(String.format("%s/HostAddress", APPDATA_ROOT), "none");
    }

    public static boolean shouldMaintainConnection() {
        return RegistryUtils.getRegistryKey(String.format("%s/MaintainConnection", APPDATA_ROOT), true);
    }

    public static boolean useActiveConnection() {
        String hostAddress = Config.getHostAddress();
        boolean useActiveConnection = !"none".equalsIgnoreCase(hostAddress);
        return useActiveConnection;
    }

    public static boolean useRTSLine() {
        return RegistryUtils.getRegistryKey(String.format("%s/UseRTSLine", APPDATA_ROOT), false);
    }
}

