/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.utils.ExternalUtils;
import com.integpg.system.JANOS;

public class UnitConfig {
    public static final String MODEL = JANOS.getRegistryString((String)"$Model", (String)"");
    public static final int SERIAL_NUMBER = JANOS.getSerialNumber();
    public static final String VERSION = JANOS.getRegistryString((String)"$Version", (String)"");

    public static boolean is410() {
        return MODEL.equals("410");
    }

    public static boolean is412() {
        return MODEL.equals("412");
    }

    public static boolean is414() {
        return MODEL.equals("414");
    }

    public static boolean is412DMX() {
        return MODEL.equals("412DMX");
    }

    public static int getInputCount() {
        String modelString = JANOS.getRegistryString((String)"$Model", (String)"");
        return modelString.startsWith("412") ? 4 : (modelString.equals("414") ? 12 : 8);
    }

    public static int getInternalOutputCount() {
        String modelString = JANOS.getRegistryString((String)"$Model", (String)"");
        int internalOutputCount = modelString.startsWith("412") ? 12 : (modelString.equals("414") ? 4 : 8);
        return internalOutputCount;
    }

    public static int getInternalOutputMask() {
        return 65535 >> 16 - UnitConfig.getInternalOutputCount();
    }

    public static int getOutputCount() {
        return UnitConfig.getInternalOutputCount() + ExternalUtils.getDeviceCountForType("fb") * 4;
    }

    public static boolean is4RoutModulePresent(int moduleIndex) {
        if (0 >= moduleIndex) {
            throw new RuntimeException("module index should be greater than zero");
        }
        String moduleIndexRegistryString = String.format("externals/deviceorder/typefb_%d", moduleIndex);
        String address = JANOS.getRegistryString((String)moduleIndexRegistryString, (String)"");
        return ExternalUtils.isPresent(address);
    }

    public static int getExternalOutputMask() {
        int externalCount = ExternalUtils.getDeviceCountForType("fb");
        int externalMask = 0;
        for (int i = 4 - UnitConfig.getInternalOutputCount() / 4; i < externalCount; ++i) {
            if (!UnitConfig.is4RoutModulePresent(i + 1)) continue;
            externalMask <<= 4;
            externalMask |= 0xF;
        }
        return externalMask;
    }

    public static String getHostname() {
        return JANOS.getRegistryString((String)"IpConfig/Hostname", (String)("jr" + JANOS.getSerialNumber()));
    }

    public static String getIpAddress() {
        return JANOS.getRegistryString((String)"ipconfig/ipaddress", (String)"");
    }
}

