App.controller('modbusController', ['$scope', function ($scope) {

    var _this = this;
    _this.running = false;

    jnrwebsocket.addOnLoggedInListener(function onLoggedIn() {
        _this.config = {
            modbusSettings: {
                "Login": "", Port: 502, Timeout: 90000
            }
        };
        _this.savedConfig;
        _this.Version;
        jnrwebsocket.subscribeRegistryKey('Run/ModbusServer', function (registryKey, registryValue) {
            if (registryValue == "flash/modbusserver.jar") {
                _this.running = true;
            }
            if (registryValue == "") {
                _this.running = false;
            }
        });
        jnrwebsocket.readRegistryKey('AppData/ModbusServer/$Version', function (registryKey, registryValue) {
            _this.Version = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/ModbusServer/Login', function (registryKey, registryValue) {
            if (registryValue == "true") {
                _this.config.modbusSettings.Login = 1;
            }
            if (registryValue == "false") {
                _this.config.modbusSettings.Login = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/ModbusServer/Port', function (registryKey, registryValue) {
            _this.config.modbusSettings.Port = parseInt(registryValue);
        });
        jnrwebsocket.readRegistryKey('AppData/ModbusServer/Timeout', function (registryKey, registryValue) {
            _this.config.modbusSettings.Timeout = parseInt(registryValue);
            _this.savedConfig = angular.copy(_this.config);
            $scope.$apply();
        });
    });

    _this.hasChanged = function (config, savedConfig) {
        var hasChanged = !angular.equals(_this.config, _this.savedConfig);
        return hasChanged;
    };

    _this.writingRegistry = function () {
        if (_this.config.modbusSettings.Login == 1) {
            jnrwebsocket.registryWrite('AppData/ModbusServer/Login', true)
        }
        if (_this.config.modbusSettings.Login == 2) {
            jnrwebsocket.registryWrite('AppData/ModbusServer/Login', false)
        }
        jnrwebsocket.registryWrite('AppData/ModbusServer/Port', _this.config.modbusSettings.Port)
        jnrwebsocket.registryWrite('AppData/ModbusServer/Timeout', _this.config.modbusSettings.Timeout)
        _this.savedConfig = angular.copy(_this.config);
        alert("Configuration Saved. A reboot may be needed for some changes to take affect.");
    }

}]);