/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPIpAddress;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPPDU;
import com.integpg.snmp.objects.SNMPTimeTicks;
import com.integpg.snmp.objects.SNMPVarBindings;
import java.io.IOException;

public class SNMPTrapPDU
extends SNMPPDU {
    private final SNMPObjectIdentifier _oid;
    private final SNMPIpAddress _agentAddress;
    private final SNMPInteger _genericTrap;
    private final SNMPInteger _specificTrap;
    private final SNMPTimeTicks _timeTicks;
    private final SNMPVarBindings _varBindingList;

    public SNMPTrapPDU(SNMPObjectIdentifier oid, SNMPIpAddress agentAddress, SNMPInteger genericTrap, SNMPInteger specificTrap, SNMPTimeTicks timeTicks, SNMPVarBindings varBindingList) {
        this._oid = oid;
        this._agentAddress = agentAddress;
        this._genericTrap = genericTrap;
        this._specificTrap = specificTrap;
        this._timeTicks = timeTicks;
        this._varBindingList = varBindingList;
    }

    @Override
    public int getTag() {
        return 164;
    }

    public SNMPObjectIdentifier getOId() {
        return this._oid;
    }

    public SNMPIpAddress getAgentAddress() {
        return this._agentAddress;
    }

    public SNMPInteger getGenericTrap() {
        return this._genericTrap;
    }

    public SNMPInteger getSpecificTrap() {
        return this._specificTrap;
    }

    public SNMPTimeTicks getTimeTicks() {
        return this._timeTicks;
    }

    public SNMPVarBindings getVarBindings() {
        return this._varBindingList;
    }

    @Override
    public void encodeBER(SNMPCodec codec) throws IOException {
        super.encodeBER(codec);
        this.getOId().encodeBER(codec);
        this.getAgentAddress().encodeBER(codec);
        this.getGenericTrap().encodeBER(codec);
        this.getSpecificTrap().encodeBER(codec);
        this.getTimeTicks().encodeBER(codec);
        this.getVarBindings().encodeBER(codec);
    }

    @Override
    public int getLength() {
        int totalLength;
        this._length = totalLength = this.getOId().getTLVLength() + this.getAgentAddress().getTLVLength() + this.getGenericTrap().getTLVLength() + this.getSpecificTrap().getTLVLength() + this.getTimeTicks().getTLVLength() + this.getVarBindings().getTLVLength();
        return this._length;
    }
}

