/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.datastructures;

import java.util.Stack;

public class BPlusTree<Key extends Comparable, Value> {
    private final Object _lock = new Object();
    private Node root;
    private int M;
    private int N;
    private int _length = 0;
    private StringBuilder _dumpBuilder;

    public BPlusTree(int n) {
        this(n, n);
    }

    public BPlusTree(int m, int n) {
        this.M = m;
        this.N = n;
        this.root = new LNode();
    }

    public int length() {
        return this._length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Key key, Value value) {
        Object object = this._lock;
        synchronized (object) {
            Split result = this.root.insert(key, value);
            if (result != null) {
                INode _root = new INode();
                _root.num = 1;
                _root.keys[0] = result.key;
                _root.children[0] = result.left;
                _root.children[1] = result.right;
                this.root = _root;
                ++this._length;
            }
        }
    }

    public Value find(Key key) {
        return this.find(this.root, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value find(Node node, Key key) {
        Object object = this._lock;
        synchronized (object) {
            if (node instanceof INode) {
                INode inner = (INode)node;
                int idx = inner.getLoc(key);
                node = inner.children[idx];
                return this.find(node, key);
            }
            if (node instanceof LNode) {
                LNode leaf = (LNode)node;
                int idx = leaf.getLoc(key);
                if (idx < leaf.num && leaf.keys[idx].equals(key)) {
                    return leaf.values[idx];
                }
                return null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value findNext(Key key) {
        Object object = this._lock;
        synchronized (object) {
            boolean keysMatch;
            int idx;
            Stack<Node> iNodeStack = new Stack<Node>();
            Node node = this.root;
            while (node instanceof INode) {
                iNodeStack.addElement(node);
                INode inner = (INode)node;
                idx = inner.getLoc(key);
                node = inner.children[idx];
            }
            LNode leaf = (LNode)node;
            idx = leaf.getLoc(key);
            boolean bl = keysMatch = null != leaf.values[idx] && null != leaf.keys[idx] && key.equals(leaf.keys[idx]);
            if (keysMatch) {
                ++idx;
            }
            if (idx < leaf.num) {
                return leaf.values[idx];
            }
            if (idx == leaf.num && key.compareTo((Comparable)leaf.keys[idx - 1]) < 0) {
                return leaf.values[idx - 1];
            }
            while (iNodeStack.size() > 0) {
                INode inner = (INode)iNodeStack.pop();
                node = inner;
                while (node instanceof INode) {
                    inner = (INode)node;
                    idx = inner.getLoc(key) + 1;
                    if (idx < inner.children.length) {
                        node = inner.children[idx];
                        continue;
                    }
                    return null;
                }
                leaf = (LNode)node;
                if (leaf == null) continue;
                return leaf.values[0];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        Object object = this._lock;
        synchronized (object) {
            this._dumpBuilder = new StringBuilder();
            this.root.dump();
            return this._dumpBuilder.toString();
        }
    }

    static class Split {
        public final Key key;
        public final Node left;
        public final Node right;
        final /* synthetic */ BPlusTree this$0;

        public Split(Key k, Node l, Node r) {
            this.this$0 = this$0;
            this.key = k;
            this.left = l;
            this.right = r;
        }
    }

    class INode
    extends Node {
        final Node[] children;

        INode() {
            this.children = new Node[BPlusTree.this.N + 1];
            this.keys = new Comparable[BPlusTree.this.N];
        }

        @Override
        public int getLoc(Key key) {
            for (int i = 0; i < this.num; ++i) {
                if (this.keys[i].compareTo(key) <= 0) continue;
                return i;
            }
            return this.num;
        }

        @Override
        public Split insert(Key key, Value value) {
            if (this.num == BPlusTree.this.N) {
                int mid = (BPlusTree.this.N + 1) / 2;
                int sNum = this.num - mid;
                INode sibling = new INode();
                sibling.num = sNum;
                System.arraycopy(this.keys, mid, sibling.keys, 0, sNum);
                System.arraycopy(this.children, mid, sibling.children, 0, sNum + 1);
                this.num = mid - 1;
                Split result = new Split(BPlusTree.this, this.keys[mid - 1], (Node)this, (Node)sibling);
                if (key.compareTo(result.key) < 0) {
                    this.insertNonfull(key, value);
                } else {
                    sibling.insertNonfull(key, value);
                }
                return result;
            }
            this.insertNonfull(key, value);
            return null;
        }

        private void insertNonfull(Key key, Value value) {
            int idx = this.getLoc(key);
            Split result = this.children[idx].insert(key, value);
            if (result != null) {
                if (idx == this.num) {
                    this.keys[idx] = result.key;
                    this.children[idx] = result.left;
                    this.children[idx + 1] = result.right;
                    ++this.num;
                } else {
                    System.arraycopy(this.keys, idx, this.keys, idx + 1, this.num - idx);
                    System.arraycopy(this.children, idx, this.children, idx + 1, this.num - idx + 1);
                    this.children[idx] = result.left;
                    this.children[idx + 1] = result.right;
                    this.keys[idx] = result.key;
                    ++this.num;
                }
            }
        }

        @Override
        public void dump() {
            BPlusTree.this._dumpBuilder.append(this);
            BPlusTree.this._dumpBuilder.append("iNode h==?");
            for (int i = 0; i < this.num; ++i) {
                this.children[i].dump();
                BPlusTree.this._dumpBuilder.append('>');
                BPlusTree.this._dumpBuilder.append(this.keys[i]);
            }
            this.children[this.num].dump();
        }
    }

    class LNode
    extends Node {
        final Value[] values;

        LNode() {
            this.values = new Object[BPlusTree.this.M];
            this.keys = new Comparable[BPlusTree.this.M];
        }

        @Override
        public int getLoc(Key key) {
            for (int i = 0; i < this.num; ++i) {
                if (this.keys[i].compareTo(key) < 0) continue;
                return i;
            }
            return this.num;
        }

        @Override
        public Split insert(Key key, Value value) {
            int i = this.getLoc(key);
            if (this.num == BPlusTree.this.M) {
                int mid = (BPlusTree.this.M + 1) / 2;
                int sNum = this.num - mid;
                LNode sibling = new LNode();
                sibling.num = sNum;
                System.arraycopy(this.keys, mid, sibling.keys, 0, sNum);
                System.arraycopy(this.values, mid, sibling.values, 0, sNum);
                this.num = mid;
                if (i < mid) {
                    this.insertNonfull(key, value, i);
                } else {
                    sibling.insertNonfull(key, value, i - mid);
                }
                Split result = new Split(BPlusTree.this, sibling.keys[0], (Node)this, (Node)sibling);
                return result;
            }
            this.insertNonfull(key, value, i);
            return null;
        }

        private void insertNonfull(Key key, Value value, int idx) {
            if (idx < this.num && this.keys[idx].equals(key)) {
                this.values[idx] = value;
            } else {
                System.arraycopy(this.keys, idx, this.keys, idx + 1, this.num - idx);
                System.arraycopy(this.values, idx, this.values, idx + 1, this.num - idx);
                this.keys[idx] = key;
                this.values[idx] = value;
                ++this.num;
            }
        }

        @Override
        public void dump() {
            BPlusTree.this._dumpBuilder.append(this);
            BPlusTree.this._dumpBuilder.append("lNode h==0");
            for (int i = 0; i < this.num; ++i) {
                BPlusTree.this._dumpBuilder.append(this.keys[i] + " = " + this.values[i]);
            }
        }
    }

    abstract class Node {
        protected int num;
        protected Key[] keys;

        Node() {
        }

        public abstract int getLoc(Key var1);

        public abstract Split insert(Key var1, Value var2);

        public abstract void dump();
    }
}

