/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messaging;

import com.integpg.janoslib.messaging.CustomMessageListener;
import com.integpg.system.SystemMsg;
import java.util.Enumeration;
import java.util.Hashtable;

public class CustomMessageHandler {
    protected final Hashtable listeners = new Hashtable();

    public void addListener(int id, CustomMessageListener listener) {
        System.out.println("Add custom listener for " + id);
        this.listeners.put(new Integer(id), listener);
    }

    public boolean shouldHandle(SystemMsg msg) {
        Enumeration e = this.listeners.keys();
        while (e.hasMoreElements()) {
            Integer id = (Integer)e.nextElement();
            if (msg.type != id) continue;
            return true;
        }
        return false;
    }

    public void notifyListeners(SystemMsg msg) {
        Enumeration e = this.listeners.keys();
        while (e.hasMoreElements()) {
            Integer id = (Integer)e.nextElement();
            if (msg.type != id) continue;
            CustomMessageListener listener = (CustomMessageListener)this.listeners.get(id);
            listener.messageReceived(msg);
        }
    }
}

