App.controller('onBootPageController', ['$scope', function ($scope) {

    var _this = this;
    const regex = /\/?(flash\/)?((serialcontrol)|(serialethernet)|(modbusserver)|(slaveservice)|(snmp)|(jbakup))(\.jar)?/gi;

    jnrwebsocket.addOnLoggedInListener(function onLoggedIn() {
        _this.config = {
            bundledSettings: {
                "enabledSerialControl": false, "enabledSerialToEthernet": false, "enabledModbusServer": false,
                "enabledSlaveService": false, "enabledSNMP": false, "enabledJBakup": false, "jBakupInstalled": false,
            }
        };
        _this.title = {
            titleSettings: {
                "serialControlTitle": "", "serialToEthernetTitle": "", "modbusTitle": "", "slavingTitle": "", "snmpTitle": "",
                "jBakupTitle": ""
            }
        }
        _this.desc = {
            descSettings: {
                "serialControlDesc": "", "serialToEthernetDesc": "", "modbusDesc": "", "slavingDesc": "", "snmpDesc": "",
                "jBakupDesc": ""
            }
        }
        _this.savedConfig;
        jnrwebsocket.readRegistryKey('Applications/SerialControl/Name', function (registryKey, registryValue) {
            _this.title.titleSettings.serialControlTitle = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/SerialControl/Desc', function (registryKey, registryValue) {
            _this.desc.descSettings.serialControlDesc = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/SerialEthernet/Name', function (registryKey, registryValue) {
            _this.title.titleSettings.serialToEthernetTitle = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/SerialEthernet/Desc', function (registryKey, registryValue) {
            _this.desc.descSettings.serialToEthernetDesc = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/ModbusServer/Name', function (registryKey, registryValue) {
            _this.title.titleSettings.modbusTitle = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/ModbusServer/Desc', function (registryKey, registryValue) {
            _this.desc.descSettings.modbusDesc = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/Slaving/Name', function (registryKey, registryValue) {
            _this.title.titleSettings.slavingTitle = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/Slaving/Desc', function (registryKey, registryValue) {
            _this.desc.descSettings.slavingDesc = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/SNMP/Name', function (registryKey, registryValue) {
            _this.title.titleSettings.snmpTitle = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/SNMP/Desc', function (registryKey, registryValue) {
            _this.desc.descSettings.snmpDesc = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/JBakup/Name', function (registryKey, registryValue) {
            _this.title.titleSettings.jBakupTitle = registryValue;
        });
        jnrwebsocket.readRegistryKey('Applications/JBakup/Desc', function (registryKey, registryValue) {
            _this.desc.descSettings.jBakupDesc = registryValue;
            _this.config.bundledSettings.jBakupInstalled = (null != registryKey);
        });
        jnrwebsocket.subscribeRegistryKey('Run/SerialControl', function (registryKey, registryValue) {
            const regValue = registryValue;
            if (regValue.match(regex) != null) {
                _this.config.bundledSettings.enabledSerialControl = true
                $("#serialControl").prop('checked', true);
            }
            if (regValue.match(regex) == null) {
                _this.config.bundledSettings.enabledSerialControl = false
            }
        });
        jnrwebsocket.subscribeRegistryKey('Run/SerialEthernet', function (registryKey, registryValue) {
            const regValue = registryValue;
            if (regValue.match(regex) != null) {
                _this.config.bundledSettings.enabledSerialToEthernet = true
                $("#serialEthernet").prop('checked', true);
            }
            if (regValue.match(regex) == null) {
                _this.config.bundledSettings.enabledSerialToEthernet = false
            }
        });
        jnrwebsocket.subscribeRegistryKey('Run/ModbusServer', function (registryKey, registryValue) {
            const regValue = registryValue;
            if (regValue.match(regex) != null) {
                _this.config.bundledSettings.enabledModbusServer = true
                $("#modbusServer").prop('checked', true);
            }
            if (regValue.match(regex) == null) {
                _this.config.bundledSettings.enabledModbusServer = false
            }
        });
        jnrwebsocket.subscribeRegistryKey('Run/Slaving', function (registryKey, registryValue) {
            const regValue = registryValue;
            if (regValue.match(regex) != null) {
                _this.config.bundledSettings.enabledSlaveService = true
                $("#slaveService").prop('checked', true);
            }
            if (regValue.match(regex) == null) {
                _this.config.bundledSettings.enabledSlaveService = false
            }
        });
        jnrwebsocket.subscribeRegistryKey('Run/SNMP', function (registryKey, registryValue) {
            const regValue = registryValue;
            if (regValue.match(regex) != null) {
                _this.config.bundledSettings.enabledSNMP = true
                $("#snmp").prop('checked', true);
            }
            if (regValue.match(regex) == null) {
                _this.config.bundledSettings.enabledSNMP = false
            }
        });
        jnrwebsocket.subscribeRegistryKey('Run/JBakup', function (registryKey, registryValue) {
            const regValue = registryValue;
            if (null != regValue) {
                if (regValue.match(regex) != null) {
                    _this.config.bundledSettings.enabledJBakup = true
                    $("#jBakup").prop('checked', true);
                }
                if (regValue.match(regex) == null) {
                    _this.config.bundledSettings.enabledJBakup = false
                }
                _this.savedConfig = angular.copy(_this.config);
            }
            $scope.$apply();
        });
    });

    _this.hasChanged = function (config, savedConfig) {
        var hasChanged = !angular.equals(_this.config, _this.savedConfig);
        return hasChanged;
    };

    _this.writingRegistry = function () {
        if (_this.config.bundledSettings.enabledSerialControl) {
            jnrwebsocket.registryWrite('Run/SerialControl', "flash/serialcontrol.jar")
        }
        else {
            jnrwebsocket.registryWrite('Run/SerialControl', "")
        }
        if (_this.config.bundledSettings.enabledSerialToEthernet) {
            jnrwebsocket.registryWrite('Run/SerialEthernet', "flash/serialethernet.jar")
        }
        else {
            jnrwebsocket.registryWrite('Run/SerialEthernet', "")
        }
        if (_this.config.bundledSettings.enabledModbusServer) {
            jnrwebsocket.registryWrite('Run/ModbusServer', "flash/modbusserver.jar")
        }
        else {
            jnrwebsocket.registryWrite('Run/ModbusServer', "")
        }
        if (_this.config.bundledSettings.enabledSlaveService) {
            jnrwebsocket.registryWrite('Run/Slaving', "flash/slaveservice.jar")
        }
        else {
            jnrwebsocket.registryWrite('Run/Slaving', "")
        }
        if (_this.config.bundledSettings.enabledSNMP) {
            jnrwebsocket.registryWrite('Run/SNMP', "flash/snmp.jar")
        }
        else {
            jnrwebsocket.registryWrite('Run/SNMP', "")
        }
        if (_this.config.bundledSettings.enabledJBakup) {
            jnrwebsocket.registryWrite('Run/JBakup', "flash/jbakup.jar");
        }
        else {
            jnrwebsocket.registryWrite('Run/JBakup', "")
        }
        _this.savedConfig = angular.copy(_this.config);
        alert("Configuration Saved. A reboot may be needed for some changes to take affect.");
    }

}]);