/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.system.JANOS;
import java.util.Hashtable;

public class MinimumVersion {
    private static final Hashtable SAVED_VERSION_RESULTS = new Hashtable();

    public static boolean atLeast(String featureName, String targetVersion) {
        if (SAVED_VERSION_RESULTS.containsKey(targetVersion)) {
            Boolean result = (Boolean)SAVED_VERSION_RESULTS.get(targetVersion);
            return result;
        }
        boolean result = MinimumVersion.atLeast(targetVersion);
        if (!result) {
            AppLog.error(featureName + " requires at least OS " + targetVersion);
        }
        SAVED_VERSION_RESULTS.put(targetVersion, result);
        return result;
    }

    public static boolean atLeast(String targetVersion) {
        if (SAVED_VERSION_RESULTS.containsKey(targetVersion)) {
            Boolean result = (Boolean)SAVED_VERSION_RESULTS.get(targetVersion);
            return result;
        }
        int targetVers = MinimumVersion.getVersionIntFromString(targetVersion);
        int[] v = JANOS.getVersionNum();
        int vers = (v[0] << 28) + (v[1] << 24) + (v[2] << 20) + (v[3] << 16) + (v[4] << 8) + v[5];
        boolean result = vers >= targetVers;
        return result;
    }

    private static int getVersionIntFromString(String version) {
        int[] versArray = new int[6];
        int offset = 0;
        int i = 0;
        while (offset >= 0 && offset < version.length()) {
            int dotPos = version.indexOf(".", offset);
            int dashPos = version.indexOf("-", offset);
            int nextPos = dotPos;
            if (nextPos == -1 || dashPos != -1 && dashPos < nextPos) {
                nextPos = dashPos;
            }
            if (nextPos == -1) {
                nextPos = version.length();
            }
            if (nextPos >= 0) {
                String match = version.substring(offset, nextPos);
                if (match.charAt(0) >= 'a') {
                    if (match.startsWith("rc")) {
                        i = 3;
                        versArray[i] = 2;
                        offset += 2;
                    } else if (match.startsWith("r")) {
                        i = 3;
                        versArray[i] = 3;
                        ++offset;
                    } else if (match.startsWith("b")) {
                        i = 3;
                        versArray[i] = 1;
                        ++offset;
                    } else if (match.startsWith("a")) {
                        i = 3;
                        versArray[i] = 0;
                        ++offset;
                    }
                } else {
                    versArray[i] = Integer.parseInt(match);
                    offset = nextPos + 1;
                }
                ++i;
                continue;
            }
            offset = -1;
        }
        int vers = (versArray[0] << 28) + (versArray[1] << 24) + (versArray[2] << 20) + (versArray[3] << 16) + (versArray[4] << 8) + versArray[5];
        return vers;
    }
}

