/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integ.common.logging.AppLog;
import com.integ.common.messagepump.MessagePumpListener;
import com.integpg.snmp.PDUSender;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPNull;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.snmp.objects.SNMPVarBindings;
import com.integpg.snmp.objects.SNMPVariablePair;
import com.integpg.snmp.objects.requests.SNMPSetRequest;
import com.integpg.system.SystemMsg;
import java.net.InetAddress;
import java.util.Json;

public class SNMPSetReceiveHandler
extends PDUSender
implements MessagePumpListener {
    public SNMPSetReceiveHandler() {
        super(161);
    }

    @Override
    public void messageReceived(SystemMsg msg) {
        if (3002 == msg.type) {
            String communityName;
            Json json = new Json(new String(msg.msg));
            System.out.println("msg: " + msg.type + " = " + json);
            String host = null;
            int port = -1;
            if (json.containsKey("host")) {
                host = json.getString("host");
            }
            if (json.containsKey("port")) {
                port = json.getInt("port");
            }
            if (null == (communityName = "private")) {
                communityName = "public";
            }
            String id = json.getString("oid");
            String type = json.getString("type");
            String value = json.getString("value");
            SNMPObject object = new SNMPNull();
            if ("string".equalsIgnoreCase(type)) {
                object = new SNMPOctetString(value);
            } else if ("integer".equalsIgnoreCase(type)) {
                object = new SNMPInteger(Integer.parseInt(value));
            }
            SNMPObjectIdentifier oid = new SNMPObjectIdentifier(id);
            this.send(oid, object, host, port, communityName);
        }
    }

    public void send(SNMPObjectIdentifier oid, SNMPObject snmpObject, String host, int port, String communityName) {
        try {
            InetAddress trapHostAddress;
            if (null == host) {
                throw new RuntimeException("Host not defined in SNMP Set Receive Handler");
            }
            if (-1 == port) {
                port = 161;
            }
            if ((trapHostAddress = InetAddress.getByName(host)) != null) {
                SNMPVarBindings varBindList = new SNMPVarBindings();
                varBindList.addPair(new SNMPVariablePair(oid, snmpObject));
                SNMPSetRequest pdu = new SNMPSetRequest(varBindList);
                this.send(trapHostAddress, port, communityName, pdu);
                System.out.println("set-request sent to " + trapHostAddress);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error sending trap", ex);
        }
    }
}

