/*
 * Decompiled with CFR 0.152.
 */
package com.integ.slaveservice;

import com.integ.slaveservice.AssemblyInfo;
import com.integ.slaveservice.LocalSlaveService;
import com.integ.slaveservice.RemoteSlaveService;
import com.integ.slaveservice.SlaveConfigInfo;
import com.integ.slaveservice.SlaveService;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.messaging.MessageLoop;
import com.integpg.janoslib.messaging.RegistryMessageListener;
import com.integpg.janoslib.system.JanosApplication;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.JANOS;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SlaveServiceMain
extends JanosApplication
implements RegistryMessageListener {
    private static final AssemblyInfo ASSEMBLY_INFO = new AssemblyInfo();
    private static final Pattern SLAVE_KEY_PATTERN = Pattern.compile("io/(inputs|outputs)/(din|rout)(\\d+)/slave", 1);
    private final Hashtable<String, SlaveService> _slaveServiceCache = new Hashtable();
    private final SlaveConfigInfo[] _inputChannelConfig = new SlaveConfigInfo[12];
    private final SlaveConfigInfo[] _outputChannelConfig = new SlaveConfigInfo[16];

    public static void main(String[] args) {
        SlaveServiceMain.exec(new SlaveServiceMain(), ASSEMBLY_INFO, args);
    }

    @Override
    public boolean shouldPreventDuplicateInstance() {
        return true;
    }

    @Override
    public void init(String[] args) {
        this._slaveServiceCache.put("localhost", LocalSlaveService.getInstance());
        String localIpAddress = JANOS.getRegistryString((String)"ipconfig/ipaddress", null);
        if (null != localIpAddress) {
            this._slaveServiceCache.put(localIpAddress, LocalSlaveService.getInstance());
        }
        MessageLoop.addRegistryListener(this);
        this.loadInititalRegistryConfig();
    }

    private void loadInititalRegistryConfig() {
        String key;
        int i;
        for (i = 0; i < UnitConfig.getInputCount(); ++i) {
            key = "IO/Inputs/din" + (i + 1) + "/Slave";
            this.processSlaveKey(key);
        }
        for (i = 0; i < 16; ++i) {
            key = "IO/Outputs/rout" + (i + 1) + "/Slave";
            this.processSlaveKey(key);
        }
    }

    @Override
    public void registryMessageReceived(String registryKey) {
        System.out.println("registry message received for " + registryKey);
        try {
            if (registryKey.toLowerCase().endsWith("slave")) {
                this.processSlaveKey(registryKey);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Error processing registry key change", ex);
        }
    }

    private void processSlaveKey(String registryKey) {
        if (!registryKey.toLowerCase().endsWith("slave")) {
            return;
        }
        System.out.println("Process: " + registryKey);
        int localRuleType = -1;
        Matcher match = SLAVE_KEY_PATTERN.matcher(registryKey);
        if (!match.find()) {
            return;
        }
        SlaveConfigInfo[] slaveConfigInfoArray = null;
        if ("inputs".equalsIgnoreCase(match.group(1)) && "din".equalsIgnoreCase(match.group(2))) {
            slaveConfigInfoArray = this._inputChannelConfig;
            localRuleType = 0;
        } else if ("outputs".equalsIgnoreCase(match.group(1)) && "rout".equalsIgnoreCase(match.group(2))) {
            slaveConfigInfoArray = this._outputChannelConfig;
            localRuleType = 1;
        }
        int localChannel = Integer.parseInt(match.group(3));
        SlaveConfigInfo slaveConfig = this.getSlaveConfig(registryKey, localChannel);
        SlaveConfigInfo previousSlaveConfig = slaveConfigInfoArray[localChannel - 1];
        this.processSlaveConfig(localRuleType, previousSlaveConfig, slaveConfig);
        slaveConfigInfoArray[localChannel - 1] = slaveConfig;
    }

    private SlaveConfigInfo getSlaveConfig(String slaveRegistryKey, int localChannel) {
        String value = JANOS.getRegistryString((String)slaveRegistryKey, (String)"");
        if ("".equals(value)) {
            return null;
        }
        System.out.println(slaveRegistryKey + "=" + value);
        try {
            SlaveConfigInfo slaveConfigInfo = new SlaveConfigInfo(value, localChannel);
            if (!"".equals(slaveConfigInfo.Password)) {
                JANOS.setRegistryString((String)(slaveRegistryKey + "Password"), (String)slaveConfigInfo.Password);
                String newRegistryKeyVal = String.format("%s, %d, %s, , %s", slaveConfigInfo.IPAddress, slaveConfigInfo.Port, slaveConfigInfo.Username, slaveConfigInfo.IOPoint);
                JANOS.setRegistryString((String)slaveRegistryKey, (String)newRegistryKeyVal);
            }
            slaveConfigInfo.Password = JANOS.getRegistryString((String)(slaveRegistryKey + "Password"), (String)"");
            System.out.println("slaveConfigInfo.Password = " + slaveConfigInfo.Password);
            return slaveConfigInfo;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error getting slave config for channel " + slaveRegistryKey, ex);
        }
    }

    private void processSlaveConfig(int localRuleType, SlaveConfigInfo previousSlaveConfig, SlaveConfigInfo slaveConfig) {
        SlaveService slaveService;
        if (null == previousSlaveConfig && null == slaveConfig) {
            return;
        }
        System.out.println("slaveConfig = " + slaveConfig);
        System.out.println("previousSlaveConfig = " + previousSlaveConfig);
        boolean ruleHasChanged = previousSlaveConfig == null && slaveConfig != null || previousSlaveConfig != null && slaveConfig == null || slaveConfig.compareTo(previousSlaveConfig) != 0;
        System.out.println("ruleHasChanged = " + ruleHasChanged);
        boolean shouldRemoveRule = previousSlaveConfig != null && ruleHasChanged;
        System.out.println("shouldRemoveRule = " + shouldRemoveRule);
        boolean shouldAddRule = slaveConfig != null && ruleHasChanged;
        System.out.println("shouldAddRule = " + shouldAddRule);
        if (shouldRemoveRule) {
            try {
                slaveService = this._slaveServiceCache.get(previousSlaveConfig.IPAddress);
                AppLog.info("previous slaving config for channel " + previousSlaveConfig.LocalChannel + ": " + previousSlaveConfig.toString());
                System.out.println(previousSlaveConfig);
                System.out.println("previousSlaveConfig.IOPoint: " + previousSlaveConfig.IOPoint);
                slaveService.removeRule(localRuleType, previousSlaveConfig.LocalChannel);
            }
            catch (Exception ex) {
                AppLog.error("error removing " + previousSlaveConfig.toString(), ex);
            }
        }
        if (shouldAddRule) {
            try {
                AppLog.info("Load slaving configuration for channel " + slaveConfig.LocalChannel + ": " + slaveConfig.toString());
                slaveService = this.getRemoteSlaveService(slaveConfig.IPAddress, slaveConfig.Port, slaveConfig.Username, slaveConfig.Password);
                System.out.println("slaveConfig.IOPoint: " + slaveConfig.IOPoint);
                if (slaveConfig.IOPoint.toLowerCase().startsWith("din")) {
                    int inputChannel = Integer.parseInt(slaveConfig.IOPoint.substring(3));
                    slaveService.addRule(localRuleType, slaveConfig.LocalChannel, 0, inputChannel, slaveConfig.Inverted);
                } else if (slaveConfig.IOPoint.toLowerCase().startsWith("rout")) {
                    int outputChannel = Integer.parseInt(slaveConfig.IOPoint.substring(4));
                    slaveService.addRule(localRuleType, slaveConfig.LocalChannel, 1, outputChannel, slaveConfig.Inverted);
                }
                if (slaveService instanceof RemoteSlaveService && null != slaveConfig.FailedCommString) {
                    slaveService.setFailedCommOutputState(slaveConfig.LocalChannel, slaveConfig.FailedCommString);
                }
            }
            catch (Exception ex) {
                AppLog.error("error processing " + slaveConfig.toString(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SlaveService getRemoteSlaveService(String ipAddress, int port, String username, String password) {
        Hashtable<String, SlaveService> hashtable = this._slaveServiceCache;
        synchronized (hashtable) {
            if (!this._slaveServiceCache.containsKey(ipAddress)) {
                System.out.println(String.format("create remote slave sersvice for %s", ipAddress));
                RemoteSlaveService rss = new RemoteSlaveService(ipAddress, port, username, password);
                this._slaveServiceCache.put(ipAddress, rss);
            }
        }
        return this._slaveServiceCache.get(ipAddress);
    }

    @Override
    public void run() throws InterruptedException {
        super.runForever();
    }
}

