/*
 * Decompiled with CFR 0.152.
 */
package com.integ.serialcontrol;

import com.integ.serialcontrol.AssemblyInfo;
import com.integ.serialcontrol.Config;
import com.integ.serialcontrol.SerialControlClient;
import com.integ.serialcontrol.UdpControlClient;
import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.COMSerialPort;
import com.integpg.janoslib.iolog.DigitalInputChannelEvent;
import com.integpg.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integpg.janoslib.iolog.DigitalOutputsIoLogMonitor;
import com.integpg.janoslib.iolog.IoChannelEvent;
import com.integpg.janoslib.iolog.IoChannelLogListener;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.net.tcp.TcpServer;
import com.integpg.janoslib.net.tcp.TcpServerEvent;
import com.integpg.janoslib.net.tcp.TcpServerListener;
import com.integpg.janoslib.net.udp.UdpConnectionListener;
import com.integpg.janoslib.net.udp.UdpServer;
import com.integpg.janoslib.net.udp.UdpServerEvent;
import com.integpg.janoslib.system.JanosApplication;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.Socket;

public class SerialControlMain
extends JanosApplication
implements IoChannelLogListener {
    private boolean _validConfiguration = false;
    private DigitalInputsIoLogMonitor _digitalInputsIoLogMonitor;
    private DigitalOutputsIoLogMonitor _relayOutputsIoLogMonitor;

    public static void main(String[] args) throws Exception {
        SerialControlMain.exec(new SerialControlMain(), new AssemblyInfo(), args);
    }

    @Override
    public void init(String[] args) {
        try {
            Config.init();
            this.setUpSerialPort();
            this.setUpTcpServer();
            this.setUpUdpServer();
            this.setIoLogMonitors();
        }
        catch (Exception ex) {
            AppLog.error("error initializing", ex);
        }
    }

    @Override
    public boolean shouldPreventDuplicateInstance() {
        return true;
    }

    private void setUpSerialPort() {
        try {
            AUXSerialPort serialPort = null;
            String serialPortName = Config.getSerialPortName();
            if ("aux".equalsIgnoreCase(serialPortName)) {
                serialPort = new AUXSerialPort();
            } else if ("rs232".equalsIgnoreCase(serialPortName) || "com".equalsIgnoreCase(serialPortName)) {
                serialPort = new COMSerialPort();
            }
            if (null != serialPort) {
                AppLog.info(String.format("opening %s serial port", serialPortName));
                serialPort.open();
                serialPort.disableReceiveTimeout();
                Logger serialLog = Logger.getLogger(String.format("%s_Serial.log", AssemblyInfo.getName()));
                SerialControlClient serialControlClient = new SerialControlClient(serialPortName + " port", (InputStream)serialPort.getInputStream(), (OutputStream)serialPort.getOutputStream());
                serialControlClient.setLog(serialLog);
                this._validConfiguration = true;
            } else {
                AppLog.info("serial port not configured to be in use");
            }
        }
        catch (Exception ex) {
            AppLog.error("error opening serial port", ex);
        }
    }

    private void setUpTcpServer() {
        try {
            int tcpServerPortNumber = Config.getTcpServerPortNumber();
            if (-1 != tcpServerPortNumber) {
                TcpServer tcpServer = new TcpServer("Serial Control Tcp Server", tcpServerPortNumber);
                tcpServer.start();
                final Logger tcpServerLog = Logger.getLogger(String.format("%s_TcpServer.log", AssemblyInfo.getName()));
                tcpServer.setTcpServerListener(new TcpServerListener(){

                    @Override
                    public void clientConnected(TcpServerEvent evt) {
                        Socket socket = evt.getSocket();
                        String clientInfo = String.format("%s:%d", socket.getInetAddress().getHostAddress(), socket.getPort());
                        tcpServerLog.info(String.format("%s is connected", clientInfo));
                        try {
                            SerialControlClient serialControlClient = new SerialControlClient(clientInfo, socket.getInputStream(), socket.getOutputStream());
                            serialControlClient.setLog(tcpServerLog);
                        }
                        catch (IOException ex) {
                            tcpServerLog.error(String.format("error setting up ascii command client for %s", clientInfo), ex);
                        }
                    }
                });
                this._validConfiguration = true;
            } else {
                AppLog.info("tcp server not configured to be in use");
            }
        }
        catch (Exception ex) {
            AppLog.error("error setting up tcp server", ex);
            JANOS.logfile((String)"errors.log", (String)String.format("[%s] %s", AssemblyInfo.getName(), ex.getMessage()));
        }
    }

    private void setUpUdpServer() {
        try {
            int udpServerPortNumber = Config.getUdpServerPortNumber();
            if (-1 != udpServerPortNumber) {
                UdpServer udpServer = new UdpServer("SerialControl-UdpServer", udpServerPortNumber);
                udpServer.start();
                final Logger udpServerLog = Logger.getLogger(String.format("%s_UdpServer.log", AssemblyInfo.getName()));
                udpServer.setListener(new UdpConnectionListener(){

                    @Override
                    public void processMessage(UdpServerEvent udpServerEvent) {
                        DatagramPacket packet = udpServerEvent.getPacket();
                        String clientInfo = String.format("%s:%d", packet.getAddress().getHostAddress(), packet.getPort());
                        udpServerLog.info(String.format("%s is connected", clientInfo));
                        try {
                            byte[] data = packet.getData();
                            String message = new String(data, 0, data.length);
                            UdpControlClient udpControlClient = new UdpControlClient(clientInfo);
                            udpControlClient.setLog(udpServerLog);
                            udpControlClient.processMessage(message);
                        }
                        catch (IOException ex) {
                            udpServerLog.error(String.format("error setting up udp command client for %s", clientInfo), ex);
                        }
                    }
                });
                this._validConfiguration = true;
            } else {
                AppLog.info("udp server not configured to be in use");
            }
        }
        catch (Exception ex) {
            AppLog.error("error setting up udp server", ex);
        }
    }

    private void setIoLogMonitors() {
        this._digitalInputsIoLogMonitor = new DigitalInputsIoLogMonitor();
        this._digitalInputsIoLogMonitor.addIoChannelLogEventListener(this);
        this._digitalInputsIoLogMonitor.start();
        this._relayOutputsIoLogMonitor = new DigitalOutputsIoLogMonitor();
        this._relayOutputsIoLogMonitor.addIoChannelLogEventListener(this);
        this._relayOutputsIoLogMonitor.start();
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        boolean sendUnsolicitedIoAlerts = Config.getSendUnsolicitedIoAlerts();
        if (sendUnsolicitedIoAlerts) {
            String outputString = String.format("%s%d=%d", ioEvent.AbbrTypeString, ioEvent.Channel, ioEvent.State ? 1 : 0);
            if (ioEvent instanceof DigitalInputChannelEvent && Config.getSendCounts()) {
                int counter = JANOS.getInputCounter((int)(ioEvent.Channel - 1));
                outputString = String.format("%s,%d", outputString, counter);
            }
            SerialControlClient.broadcast(outputString, ioEvent.TransitionTime);
        }
    }

    @Override
    public void run() {
        if (this._validConfiguration) {
            this.sleepForever();
        } else {
            AppLog.warn("nothing to do since there was either not valid configuration or errors occured");
            this.exit(0);
        }
    }
}

