/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.iolog;

import com.integpg.janoslib.iolog.DigitalOutputChannelEvent;
import com.integpg.janoslib.iolog.IoChannelLogListener;
import com.integpg.janoslib.iolog.IoLogMonitor;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.IoEvent;
import com.integpg.system.JANOS;

public class DigitalOutputsIoLogMonitor
extends IoLogMonitor {
    protected static IoEvent _lastOutputEvent;
    private int _channel = -1;

    public DigitalOutputsIoLogMonitor() {
    }

    public DigitalOutputsIoLogMonitor(int channel) {
        this._channel = channel;
    }

    public static IoEvent getLastOutputEvent() {
        return _lastOutputEvent;
    }

    @Override
    public void alertIoChannelListeners(IoEvent ioEvent) {
        _lastOutputEvent = ioEvent;
        if (0 != this._ioChannelLogEventListeners.size()) {
            for (int chan = 0; chan < 16; ++chan) {
                if (1 != (ioEvent.mask >> chan & 1)) continue;
                int state = ioEvent.states >> chan & 1;
                DigitalOutputChannelEvent digitalOutputEvent = new DigitalOutputChannelEvent();
                digitalOutputEvent.Channel = chan + 1;
                digitalOutputEvent.TransitionTime = ioEvent.timestamp;
                digitalOutputEvent.State = 1 == state;
                digitalOutputEvent.UsageMeter = JANOS.getUsageMeter((int)(chan + UnitConfig.getInputCount()));
                for (IoChannelLogListener ioChannelListener : this._ioChannelLogEventListeners) {
                    ioChannelListener.onIoChannelEvent(digitalOutputEvent);
                }
            }
        }
    }

    @Override
    protected IoEvent[] getIoEvents() {
        if (-1 == this._channel) {
            return this._iolog.getOutputEvents();
        }
        long[] transitionTimes = this._iolog.getOutputTransitions(this._channel - 1);
        IoEvent[] ioEvents = new IoEvent[transitionTimes.length];
        for (int i = 0; i < transitionTimes.length; ++i) {
            ioEvents[i] = this._iolog.getOutputEvent(transitionTimes[i]);
        }
        return ioEvents;
    }
}

