/*
 * Decompiled with CFR 0.152.
 */
package com.integ.serialcontrol;

import com.integ.serialcontrol.Config;
import com.integ.serialcontrol.Jrmon;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.net.AsciiCommandClient;
import com.integpg.janoslib.net.BytesReceivedEvent;
import com.integpg.janoslib.net.ClientListener;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.JANOS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SerialControlClient
implements ClientListener {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yy HH:mm:ss.fff");
    private static final Pattern IO_CONTROL_PATTERN = Pattern.compile("([copt\\+\\d\\*]+(=\\d+)?)$", 1);
    private static final Pattern DIN_QUERY_PATTERN = Pattern.compile("din(\\d+)\\?$", 1);
    private static final Pattern ROUT_QUERY_PATTERN = Pattern.compile("rout(\\d+)\\?$", 1);
    private static final ArrayList<SerialControlClient> CLIENTS = new ArrayList();
    private Logger _log = Logger.getLogger();
    private final String _clientNameString;
    private final OutputStream _outputStream;
    private final ByteArrayOutputStream _byteArrayOutputStream = new ByteArrayOutputStream();
    private final AsciiCommandClient _asciiCommandClient;

    private static void testPattern(String patterString) {
        try {
            Matcher matcher = IO_CONTROL_PATTERN.matcher(patterString);
            boolean found = matcher.find();
            System.out.println(String.format("matcher.find(%s) = %s", patterString, String.valueOf(found)));
            if (found) {
                Jrmon.parseCommand(matcher.group(1));
                Thread.sleep(2000L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SerialControlClient(String clientNameString, InputStream inputStream, OutputStream outputStream) {
        this._clientNameString = clientNameString;
        this._outputStream = outputStream;
        this._asciiCommandClient = new AsciiCommandClient(clientNameString, inputStream);
        this._asciiCommandClient.setTerminationBytes(Config.getIncomingTerminationString());
        this._asciiCommandClient.setClientListener(this);
        this._asciiCommandClient.start();
    }

    public void setLog(Logger log) {
        this._log = log;
        this._asciiCommandClient.setLog(this._log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcast(String s, long timestamp) {
        ArrayList<SerialControlClient> arrayList = CLIENTS;
        synchronized (arrayList) {
            for (SerialControlClient serialControlClient : CLIENTS) {
                try {
                    serialControlClient.send(s, timestamp);
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void send(String s) {
        this.send(s, System.currentTimeMillis());
    }

    public synchronized void send(String s, long timestamp) {
        try {
            this._byteArrayOutputStream.reset();
            if (Config.getSendDateStamp()) {
                this._byteArrayOutputStream.write(QUICK_DATE_FORMAT.format(timestamp).getBytes());
                this._byteArrayOutputStream.write(32);
            }
            this._byteArrayOutputStream.write(s.getBytes());
            this._byteArrayOutputStream.write(Config.getOutgoingTerminationString().getBytes());
            if (this._outputStream != null) {
                this._outputStream.write(this._byteArrayOutputStream.toByteArray());
                this._outputStream.flush();
                this._log.info(this._clientNameString + " sent: " + s);
            }
        }
        catch (IOException ex) {
            this._log.error(ex);
            AppLog.error(ex);
        }
    }

    @Override
    public void bytesReceived(BytesReceivedEvent evt) {
        byte[] bytes = evt.getBytes();
        String message = new String(bytes);
        this._log.info(String.format("%s received: %s", this._clientNameString, message));
        try {
            this.processMessage(message);
        }
        catch (IOException ex) {
            this._log.error(ex);
            AppLog.error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientStarted(EventObject evt) {
        this._log.info(this._clientNameString + " client started");
        ArrayList<SerialControlClient> arrayList = CLIENTS;
        synchronized (arrayList) {
            CLIENTS.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientFinished(EventObject evt) {
        this._log.info(this._clientNameString + " client finished");
        ArrayList<SerialControlClient> arrayList = CLIENTS;
        synchronized (arrayList) {
            if (CLIENTS.contains(this)) {
                CLIENTS.remove(this);
            }
        }
    }

    private void processMessage(String message) throws IOException {
        Matcher matcher = IO_CONTROL_PATTERN.matcher(message);
        if (matcher.find()) {
            if (1 < matcher.groupCount()) {
                Jrmon.parseCommand(matcher.group(1));
            }
        } else {
            matcher = DIN_QUERY_PATTERN.matcher(message);
            if (matcher.find()) {
                int channelNumber = Integer.parseInt(matcher.group(1));
                int state = JANOS.getInputStates() >> channelNumber - 1 & 1;
                String response = String.format("din%d=%d", channelNumber, state);
                if (Config.getSendCounts()) {
                    int counter = JANOS.getInputCounter((int)(channelNumber - 1));
                    response = String.format("%s,%d", response, counter);
                }
                this.send(response);
            } else {
                matcher = ROUT_QUERY_PATTERN.matcher(message);
                if (matcher.find()) {
                    int channelNumber = Integer.parseInt(matcher.group(1));
                    int state = JANOS.getOutputStates() >> channelNumber - 1 & 1;
                    String response = String.format("rout%d=%d", channelNumber, state);
                    this.send(response);
                } else {
                    this.send("unknown command: '" + message + "'");
                }
            }
        }
    }
}

