/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPRequestPDU;
import com.integpg.snmp.objects.SNMPVarBindings;
import java.io.IOException;

public abstract class SNMPv1RequestPDU
extends SNMPRequestPDU {
    private SNMPInteger _requestId;
    private SNMPInteger _errorStatus;
    private SNMPInteger _errorIndex;
    private SNMPVarBindings _varBindingList;

    @Override
    public void decodeBER(SNMPCodec codec) throws IOException {
        super.decodeBER(codec);
        this._requestId = (SNMPInteger)codec.getNextSnmpObject();
        this._errorStatus = (SNMPInteger)codec.getNextSnmpObject();
        this._errorIndex = (SNMPInteger)codec.getNextSnmpObject();
        int tag = codec.getTag();
        this._varBindingList = new SNMPVarBindings();
        this._varBindingList.decodeBER(codec);
    }

    @Override
    public SNMPInteger getRequestId() {
        return this._requestId;
    }

    @Override
    public SNMPInteger getErrorStatus() {
        return this._errorStatus;
    }

    @Override
    public void setErrorStatus(int errorStatus) {
        this._errorStatus = new SNMPInteger(errorStatus);
    }

    @Override
    public SNMPInteger getErrorIndex() {
        return this._errorIndex;
    }

    @Override
    public void setErrorIndex(int errorIndex) {
        this._errorIndex = new SNMPInteger(errorIndex);
    }

    @Override
    public SNMPVarBindings getVarBindings() {
        return this._varBindingList;
    }

    @Override
    public void encodeBER(SNMPCodec codec) throws IOException {
        super.encodeBER(codec);
        this.getRequestId().encodeBER(codec);
        this.getErrorStatus().encodeBER(codec);
        this.getErrorIndex().encodeBER(codec);
        this.getVarBindings().encodeBER(codec);
    }

    @Override
    public abstract void setResponse();

    @Override
    public int getLength() {
        int totalLength;
        this._length = totalLength = this.getRequestId().getTLVLength() + this.getErrorStatus().getTLVLength() + this.getErrorIndex().getTLVLength() + this.getVarBindings().getTLVLength();
        return this._length;
    }

    @Override
    public String toString() {
        return "SNMP PDU: \r\n      request id: " + this.getRequestId() + "\r\n      error status: " + this.getErrorStatus() + "\r\n      error index: " + this.getErrorIndex() + "\r\n      var bindings: " + this.getVarBindings();
    }
}

