/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.snmp.objects.SNMPGetNextRequest;
import com.integpg.snmp.objects.SNMPGetRequest;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPNull;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.snmp.objects.SNMPSequence;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SNMPCodec {
    private InputStream _inStream;
    private OutputStream _outStream;

    public SNMPCodec(InputStream inStream) {
        this._inStream = inStream;
    }

    public SNMPCodec(OutputStream outStream) {
        this._outStream = outStream;
    }

    public SNMPObject getNextSnmpObject() throws IOException {
        if (0 < this._inStream.available()) {
            int tag = this._inStream.read();
            return this.getNextSnmpObject(tag);
        }
        return null;
    }

    public SNMPObject getNextSnmpObject(int tag) throws IOException {
        SNMPObject snmpObject = null;
        if (0 < this._inStream.available()) {
            switch (tag) {
                case 48: {
                    snmpObject = new SNMPSequence();
                    break;
                }
                case 2: {
                    snmpObject = new SNMPInteger();
                    break;
                }
                case 4: {
                    snmpObject = new SNMPOctetString();
                    break;
                }
                case 6: {
                    snmpObject = new SNMPObjectIdentifier();
                    break;
                }
                case 160: {
                    snmpObject = new SNMPGetRequest();
                    break;
                }
                case 161: {
                    snmpObject = new SNMPGetNextRequest();
                    break;
                }
                case 5: 
                case 68: {
                    snmpObject = new SNMPNull();
                    break;
                }
                default: {
                    System.out.println("Unknown snmp type");
                }
            }
        }
        if (null != snmpObject) {
            snmpObject.decodeBER(this);
        }
        return snmpObject;
    }

    public int getTag() throws IOException {
        return this._inStream.read();
    }

    public int decodeLength() throws IOException {
        int dataLength = 0;
        int unsignedValue = this._inStream.read();
        if (unsignedValue < 0) {
            unsignedValue += 256;
        }
        if (unsignedValue / 128 < 1) {
            dataLength = unsignedValue;
        } else {
            int numBytes = unsignedValue % 128;
            dataLength = 0;
            for (int i = 0; i < numBytes; ++i) {
                unsignedValue = this._inStream.read();
                if (unsignedValue < 0) {
                    unsignedValue += 256;
                }
                dataLength = dataLength * 256 + unsignedValue;
            }
        }
        return dataLength;
    }

    public void encodeLength(int length) throws IOException {
        if (length < 128) {
            this._outStream.write(length);
        } else {
            int numBytes = 0;
            int temp = length;
            while (temp > 0) {
                ++numBytes;
                temp = (int)Math.floor(temp / 256);
            }
            byte num = (byte)numBytes;
            num = (byte)(num + 128);
            this._outStream.write(num);
            byte[] len = new byte[numBytes];
            for (int i = numBytes - 1; i >= 0; --i) {
                len[i] = (byte)(length % 256);
                length = (int)Math.floor(length / 256);
            }
            this._outStream.write(len, 0, numBytes);
        }
    }

    public static int bytesNeededForValue(long value) {
        if (value < 128L) {
            return 1;
        }
        int numBytes = 0;
        long temp = value;
        while (temp > 0L) {
            ++numBytes;
            temp = (int)Math.floor(temp / 128L);
        }
        return numBytes;
    }

    public int read() throws IOException {
        return this._inStream.read();
    }

    public void read(byte[] bytes) throws IOException {
        this._inStream.read(bytes);
    }

    public void write(int b) throws IOException {
        this._outStream.write(b);
    }

    public void write(byte[] bytes) throws IOException {
        this._outStream.write(bytes);
    }
}

