/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.JanosLib;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.system.AssemblyInfoBase;
import com.integpg.janoslib.system.ReleaseInfo;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.text.JDateFormat;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.ApplicationUtils;
import com.integpg.janoslib.utils.ExceptionUtils;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.system.JANOS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Json;

public class Application2 {
    private static final JDateFormat DATE_FORMAT = new JDateFormat().includeMilliseconds(true);
    public static long Start = System.currentTimeMillis();
    private static AssemblyInfoBase _assemblyBase;
    private static String _instanceName;
    private static String _registryRoot;
    private static boolean _isBackground;

    public static void init(AssemblyInfoBase assemblyInfo) {
        Application2.init(assemblyInfo, null);
    }

    public static void init(AssemblyInfoBase assemblyInfo, String instanceName) {
        boolean isForeground;
        _assemblyBase = assemblyInfo;
        _instanceName = instanceName;
        AppLog.init(assemblyInfo.getName());
        _registryRoot = "AppData/" + _assemblyBase.getName() + "/";
        if (null != _instanceName) {
            _registryRoot = _registryRoot + _instanceName + "/";
        }
        JANOS.setRegistryString((String)(_registryRoot + "$Name"), (String)_assemblyBase.getName());
        JANOS.setRegistryString((String)(_registryRoot + "$Version"), (String)_assemblyBase.getVersion());
        JANOS.setRegistryString((String)(_registryRoot + "$BuildTime"), (String)_assemblyBase.getBuildTime());
        JANOS.setRegistryString((String)(_registryRoot + "$JanosLibVersion"), (String)JanosLib.getVersion());
        JANOS.setRegistryString((String)(_registryRoot + "$JanosLibBuildTime"), (String)JanosLib.getBuildTime());
        JANOS.setRegistryString((String)(_registryRoot + "$ExecutionTime"), (String)String.valueOf(System.currentTimeMillis()));
        JANOS.setRegistryString((String)(_registryRoot + "$pid"), (String)String.valueOf(JANOS.getProcessID()));
        _isBackground = ApplicationUtils.isBackground();
        Application2.logBanner();
        boolean bl = isForeground = !_isBackground;
        if (isForeground) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static String getAppName() {
        return _assemblyBase.getName();
    }

    public static String getAppInstanceName() {
        String name = _assemblyBase.getName();
        if (null != Application2.getInstanceName()) {
            name = name + "-" + _instanceName;
        }
        return name;
    }

    public static String getAppVersion() {
        return _assemblyBase.getVersion();
    }

    public static String getInstanceName() {
        return _instanceName;
    }

    public static String getUuid() {
        return _assemblyBase.getUUID();
    }

    public static String getRegistryRoot() {
        return _registryRoot;
    }

    public static boolean isBackground() {
        return _isBackground;
    }

    public static void loaded() {
        double elapsedSeconds = (double)(System.currentTimeMillis() - Start) / 1000.0;
        AppLog.info(String.format("Application Loaded in %.3f", elapsedSeconds));
    }

    public static String printReleaseNotes(AssemblyInfoBase assemblyBase) {
        StringBuilder sb = new StringBuilder();
        sb.append("Version: " + assemblyBase.getVersion() + "\r\n\r\n");
        ReleaseInfo[] releaseNotes = AssemblyInfoBase.getReleaseNotes();
        if (null != releaseNotes) {
            for (ReleaseInfo releaseInfo : releaseNotes) {
                String releaseInfoString = releaseInfo.getVersion() + "          ";
                releaseInfoString = releaseInfoString.substring(0, 10) + releaseInfo.getDate();
                sb.append(releaseInfoString + "\r\n");
                for (String note : releaseInfo.getReleaseNotes()) {
                    int maxLineLength = 90;
                    int pos = 0;
                    int endPos = 0;
                    while (pos < note.length()) {
                        if (note.length() < (endPos += maxLineLength)) {
                            endPos = note.length();
                        } else {
                            int lastSpacePos = note.lastIndexOf(" ", endPos);
                            if (pos < lastSpacePos) {
                                endPos = lastSpacePos + 1;
                            }
                        }
                        if (0 == pos) {
                            sb.append("        * ");
                        } else {
                            sb.append("          ");
                        }
                        sb.append(note.substring(pos, endPos) + "\r\n");
                        pos = endPos;
                    }
                }
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }

    private static Json getReleaseNotesJson(AssemblyInfoBase assemblyBase) {
        ReleaseInfo[] releaseNotesArray = assemblyBase.getReleaseNotes();
        if (null != releaseNotesArray) {
            Json json = new Json();
            json.put("CurrentVersion", (Object)assemblyBase.getVersion());
            json.put("BuildTime", (Object)assemblyBase.getBuildTime());
            ArrayList<Json> releaseInfoJsonArray = new ArrayList<Json>();
            for (ReleaseInfo releaseInfo : assemblyBase.getReleaseNotes()) {
                Json releaseInfoJson = new Json();
                releaseInfoJson.put("Version", (Object)releaseInfo.getVersion());
                releaseInfoJson.put("Date", (Object)releaseInfo.getDate());
                releaseInfoJson.put("Notes", (Object)((String[])releaseInfo.getReleaseNotes().toArray()));
                releaseInfoJsonArray.add(releaseInfoJson);
            }
            json.put("ReleaseNotes", (Object)((Json[])releaseInfoJsonArray.toArray()));
            return json;
        }
        return null;
    }

    private static void logBanner() {
        Object[] objectArray = new Object[6];
        objectArray[0] = Application2.getAppInstanceName();
        objectArray[1] = _assemblyBase.getVersion();
        objectArray[2] = _assemblyBase.getBuildTime();
        objectArray[3] = JanosLib.getVersion();
        objectArray[4] = JanosLib.getBuildTime();
        objectArray[5] = JANOS.getVersion();
        String versionString = String.format("%s v%s (built %s) using JanosLib v%s (built %s) running on JANOS %s", objectArray);
        JANOS.syslog((String)versionString);
        AppLog.vital(versionString);
        AppLog.info(String.format("  %s running on S/N: %d, Model: %s", Application2.getAppInstanceName(), UnitConfig.SERIAL_NUMBER, UnitConfig.MODEL));
        Application2.updateBootLog(versionString);
    }

    private static void updateBootLog(String versionString) {
        try {
            String entry = String.format("%s, %s\r\n", DATE_FORMAT.format(System.currentTimeMillis()), versionString);
            File bootlogFile = new File(Application2.getAppName().toLowerCase() + "_boot.log");
            if (16384L < bootlogFile.length() + (long)entry.length()) {
                File bakFile = new File(bootlogFile.getPath() + ".bak");
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                bootlogFile.renameTo(bakFile);
            }
            FileUtils.appendAllBytes(bootlogFile.getPath(), entry.getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void sleepForever() {
        try {
            AppLog.info("sleep forever...");
            Thread.sleep(Integer.MAX_VALUE);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static void fatal(Object object) {
        Application2.fatal(new RuntimeException(object.toString()));
    }

    public static void fatal(Exception ex) {
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        System.err.println(String.format("%s: %s", QuickDateFormat.getDefault().format(), stackTrace));
        System.exit(-1);
    }

    static {
        _instanceName = null;
        _registryRoot = "";
        _isBackground = false;
    }
}

