/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.Type28;
import com.integpg.janoslib.externalio.Type7E;
import com.integpg.janoslib.externalio.TypeFB;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.utils.ExternalUtils;
import com.integpg.snmp.SNMPStore;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.system.JANOS;
import java.text.DecimalFormat;

class ExternalModuleInteregator
implements Runnable {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000");
    private static Thread _thread;
    private String[] _allDeviceTypeOrderStrings;
    private long _lastDeviceOrderRegistryModifiedTime = 0L;

    ExternalModuleInteregator() {
    }

    static void start() {
        if (null == _thread) {
            _thread = new Thread(new ExternalModuleInteregator());
            _thread.setName("external-module-interegator");
            _thread.start();
        }
    }

    @Override
    public void run() {
        while (true) {
            this.doLoop();
            this.doSleep();
        }
    }

    private void doLoop() {
        String[] presentDevices;
        for (String presentDeviceAddress : presentDevices = JANOS.getRegistryKey((String)"externals/$present")) {
            try {
                int index = ExternalUtils.getIndexForAddress(presentDeviceAddress);
                String typeString = presentDeviceAddress.substring(presentDeviceAddress.length() - 2);
                ExternalModule device = null;
                switch (typeString.toLowerCase()) {
                    case "28": {
                        device = Type28.getByIndex(index);
                        break;
                    }
                    case "7e": {
                        device = Type7E.getByIndex(index);
                        break;
                    }
                    case "fb": {
                        device = TypeFB.getByIndex(index);
                        break;
                    }
                    case "fd": {
                        device = TypeFD.getByIndex(index);
                        break;
                    }
                    case "fe": {
                        device = TypeFE.getByIndex(index);
                    }
                }
                if (null == device) continue;
                device.read();
                if (!device.hasChanged()) continue;
                if (device instanceof Type28) {
                    this.updateTemperatureProbe((Type28)device, device.TypeIndex);
                    continue;
                }
                if (device instanceof Type7E) {
                    this.updateEnvironmentalSensor((Type7E)device, device.TypeIndex);
                    continue;
                }
                if (device instanceof TypeFD) {
                    this.updateTenVoltModule((TypeFD)device, device.TypeIndex);
                    continue;
                }
                if (!(device instanceof TypeFE)) continue;
                this.updateFourTwentyModule((TypeFE)device, device.TypeIndex);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    private void updateTemperatureProbe(Type28 type28, int moduleIndex) {
        System.out.println("updateTemperatureProbe " + moduleIndex);
        int type = 40;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(type28.getTempC())));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(type28.getTempF())));
    }

    private void updateEnvironmentalSensor(Type7E type7E, int moduleIndex) {
        System.out.println("updateEnvironmentalSensor " + moduleIndex);
        int type = 126;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(type7E.getTempC())));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(type7E.getTempF())));
        SNMPStore.insertPair(baseOid + "4." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(type7E.getHumidity())));
    }

    private void updateTenVoltModule(TypeFD typeFD, int moduleIndex) {
        System.out.println("updateTenVoltModule " + moduleIndex);
        int type = 253;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(1))));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(2))));
        SNMPStore.insertPair(baseOid + "4." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(3))));
        SNMPStore.insertPair(baseOid + "5." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledInput(4))));
        SNMPStore.insertPair(baseOid + "6." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledOutput(1))));
        SNMPStore.insertPair(baseOid + "7." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFD.getScaledOutput(2))));
    }

    private void updateFourTwentyModule(TypeFE typeFE, int moduleIndex) {
        System.out.println("updateFourTwentyModule " + moduleIndex);
        int type = 254;
        String baseOid = "1.3.6.1.4.1.31976.1.1.5." + type + ".1.";
        SNMPStore.insertPair(baseOid + "1." + moduleIndex, new SNMPInteger(moduleIndex));
        SNMPStore.insertPair(baseOid + "2." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(1))));
        SNMPStore.insertPair(baseOid + "3." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(2))));
        SNMPStore.insertPair(baseOid + "4." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(3))));
        SNMPStore.insertPair(baseOid + "5." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledInput(4))));
        SNMPStore.insertPair(baseOid + "6." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledOutput(1))));
        SNMPStore.insertPair(baseOid + "7." + moduleIndex, new SNMPOctetString(DECIMAL_FORMAT.format(typeFE.getScaledOutput(2))));
    }

    private void doSleep() {
        try {
            int externalQueryInterval = 5000;
            Thread.sleep(externalQueryInterval);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

