App.controller('serialControlController', ['$scope', function ($scope) {

    var _this = this;
    _this.running = false;

    jnrwebsocket.addOnLoggedInListener(function onLoggedIn() {
        _this.config = {
            serialControlSettings: {
                IncomingTerminationString: "\\n", OutgoingTerminationString: "\\n", "sendCountStatus": "2",
                "sendDateStamp": "1", "sendIoStatus": "1", serialPort: "none", tcpPort: -1, udpPort: -1,
            }
        };
        _this.savedConfig;
        _this.Version;
        jnrwebsocket.subscribeRegistryKey('Run/SerialControl', function (registryKey, registryValue) {
            if (registryValue == "flash/serialcontrol.jar") {
                _this.running = true;
            }
            if (registryValue == "") {
                _this.running = false;
            }
        });
        jnrwebsocket.readRegistryKey('AppData/SerialControl/$Version', function (registryKey, registryValue) {
            _this.Version = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/SerialControl/IncomingTerminationString', function (registryKey, registryValue) {
            _this.config.serialControlSettings.IncomingTerminationString = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/SerialControl/OutgoingTerminationString', function (registryKey, registryValue) {
            _this.config.serialControlSettings.OutgoingTerminationString = registryValue;
        });
        jnrwebsocket.readRegistryKey('AppData/SerialControl/SendCounts', function (registryKey, registryValue) {
            if (registryValue == "true") {
                _this.config.serialControlSettings.sendCountStatus = 1;
            }
            if (registryValue == "false") {
                _this.config.serialControlSettings.sendCountStatus = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/SerialControl/SendDateStamp', function (registryKey, registryValue) {
            if (registryValue == "true") {
                _this.config.serialControlSettings.sendDateStamp = 1;
            }
            if (registryValue == "false") {
                _this.config.serialControlSettings.sendDateStamp = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/SerialControl/SendUnsolicitedIoAlerts', function (registryKey, registryValue) {
            if (registryValue == "true") {
                _this.config.serialControlSettings.sendIoStatus = 1;
            }
            if (registryValue == "false") {
                _this.config.serialControlSettings.sendIoStatus = 2
            }
        });
        jnrwebsocket.readRegistryKey('AppData/SerialControl/SerialPort', function (registryKey, registryValue) {
            if (registryValue == "AUX") {
                _this.config.serialControlSettings.serialPort = "AUX";
            }
            if (registryValue == "COM") {
                _this.config.serialControlSettings.serialPort = "COM";
            }
            if (registryValue == "none") {
                _this.config.serialControlSettings.serialPort = "none";
            }
        });
        jnrwebsocket.readRegistryKey('AppData/SerialControl/TcpServerPortNumber', function (registryKey, registryValue) {
            _this.config.serialControlSettings.tcpPort = parseInt(registryValue);
        });
        jnrwebsocket.readRegistryKey('AppData/SerialControl/UdpServerPortNumber', function (registryKey, registryValue) {
            _this.config.serialControlSettings.udpPort = parseInt(registryValue);
            _this.savedConfig = angular.copy(_this.config);
            $scope.$apply();
        });
    });


    _this.hasChanged = function (config, savedConfig) {
        var hasChanged = !angular.equals(_this.config, _this.savedConfig);
        return hasChanged;
    };

    _this.writingRegistry = function () {
        jnrwebsocket.registryWrite('AppData/SerialControl/IncomingTerminationString', _this.config.serialControlSettings.IncomingTerminationString)
        jnrwebsocket.registryWrite('AppData/SerialControl/OutgoingTerminationString', _this.config.serialControlSettings.OutgoingTerminationString)
        if (_this.config.serialControlSettings.sendCountStatus == 1) {
            jnrwebsocket.registryWrite('AppData/SerialControl/SendCounts', true)
        }
        if (_this.config.serialControlSettings.sendCountStatus == 2) {
            jnrwebsocket.registryWrite('AppData/SerialControl/SendCounts', false)
        }
        if (_this.config.serialControlSettings.sendDateStamp == 1) {
            jnrwebsocket.registryWrite('AppData/SerialControl/SendDateStamp', true)
        }
        if (_this.config.serialControlSettings.sendDateStamp == 2) {
            jnrwebsocket.registryWrite('AppData/SerialControl/SendDateStamp', false)
        }
        if (_this.config.serialControlSettings.sendIoStatus == 1) {
            jnrwebsocket.registryWrite('AppData/SerialControl/SendUnsolicitedIoAlerts', true)
        }
        if (_this.config.serialControlSettings.sendIoStatus == 2) {
            jnrwebsocket.registryWrite('AppData/SerialControl/SendUnsolicitedIoAlerts', false)
        }
        if (_this.config.serialControlSettings.serialPort == "AUX") {
            jnrwebsocket.registryWrite('AppData/SerialControl/SerialPort', "AUX")
        }
        if (_this.config.serialControlSettings.serialPort == "COM") {
            jnrwebsocket.registryWrite('AppData/SerialControl/SerialPort', "COM")
        }
        if (_this.config.serialControlSettings.serialPort == "none") {
            jnrwebsocket.registryWrite('AppData/SerialControl/SerialPort', "none")
        }
        jnrwebsocket.registryWrite('AppData/SerialControl/TcpServerPortNumber', _this.config.serialControlSettings.tcpPort)
        jnrwebsocket.registryWrite('AppData/SerialControl/UdpServerPortNumber', _this.config.serialControlSettings.udpPort)
        _this.savedConfig = angular.copy(_this.config);
        alert("Configuration Saved. A reboot may be needed for some changes to take affect.");
    }

}]);