/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.snmp.Config;
import com.integpg.snmp.SNMPStore;
import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPIpAddress;
import com.integpg.snmp.objects.SNMPMessage;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.snmp.objects.SNMPTrapPDU;
import com.integpg.snmp.objects.SNMPVarBindings;
import com.integpg.snmp.objects.SNMPVariablePair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class TrapSender {
    public static final int SNMP_TRAP_PORT = 162;
    private int _remotePort = 162;
    private DatagramSocket _datagramSocket = new DatagramSocket();

    public void sendTrap(SNMPObjectIdentifier oid, SNMPObject snmpObject, String communityName) {
        try {
            InetAddress trapHostAddress;
            String trapHostString = Config.getTrapHost();
            if (null != trapHostString && !"0.0.0.0".equals(trapHostString) && (trapHostAddress = InetAddress.getByName(trapHostString)) != null) {
                SNMPVarBindings varBindList = new SNMPVarBindings();
                varBindList.addPair(new SNMPVariablePair(oid, snmpObject));
                SNMPTrapPDU pdu = new SNMPTrapPDU(oid, new SNMPIpAddress(InetAddress.getLocalHost().getHostAddress()), new SNMPInteger(6L), new SNMPInteger(0L), SNMPStore.SYSTEM_UPTIME, varBindList);
                this.sendTrap(trapHostAddress, communityName, pdu);
                System.out.println("trap sent to " + trapHostAddress);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error sending trap", ex);
        }
    }

    public void sendTrap(int version, InetAddress hostAddress, String community, SNMPTrapPDU pdu) throws IOException {
        SNMPMessage message = new SNMPMessage(new SNMPInteger(version), new SNMPOctetString(community), pdu);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        SNMPCodec outCodec = new SNMPCodec(baout);
        message.encodeBER(outCodec);
        byte[] outBytes = baout.toByteArray();
        System.out.println(HexUtils.hexDump(outBytes, 0, outBytes.length));
        DatagramPacket outPacket = new DatagramPacket(outBytes, outBytes.length, hostAddress, this._remotePort);
        this._datagramSocket.send(outPacket);
    }

    public void sendTrap(InetAddress hostAddress, String community, SNMPTrapPDU pdu) throws IOException {
        int version = 0;
        this.sendTrap(version, hostAddress, community, pdu);
    }
}

