/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integpg.janoslib.internalio.IOChangedListener;
import com.integpg.janoslib.internalio.IOMonitor;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.messaging.MessageLoop;
import com.integpg.janoslib.system.JanosApplication;
import com.integpg.snmp.Agent;
import com.integpg.snmp.AgentInterface;
import com.integpg.snmp.AssemblyInfo;
import com.integpg.snmp.Config;
import com.integpg.snmp.ExternalModuleInteregator;
import com.integpg.snmp.OidReceiveHandler;
import com.integpg.snmp.SNMPStore;
import com.integpg.snmp.TrapReceiveHandler;
import com.integpg.snmp.TrapSender;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.snmp.objects.SNMPRequestPDU;
import com.integpg.snmp.objects.SNMPVarBindings;
import com.integpg.snmp.objects.SNMPVariablePair;
import com.integpg.snmp.objects.exceptions.SNMPBadValueException;
import com.integpg.system.JANOS;
import java.net.SocketException;
import java.util.EventObject;
import java.util.Vector;

public class SnmpMain
extends JanosApplication
implements AgentInterface,
IOChangedListener {
    private TrapSender _trapSender;

    public static void main(String[] args) {
        try {
            JanosApplication.exec(new SnmpMain(), AssemblyInfo.getInstance(), args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean shouldPreventDuplicateInstance() {
        return true;
    }

    @Override
    public void init(String[] args) {
        try {
            SNMPStore.init();
            Config.load();
            this._trapSender = new TrapSender();
            MessageLoop.addCustomMessageListeners(3000, new OidReceiveHandler());
            MessageLoop.addCustomMessageListeners(3001, new TrapReceiveHandler(this._trapSender));
            IOMonitor.addListener(this);
            IOMonitor.start();
            Agent agent = new Agent();
            agent.setAgentInterface(this);
            agent.listen();
            this.sendBootCompleteTrap();
            ExternalModuleInteregator.start();
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void ioChanged(EventObject event) {
        System.out.println(IOMonitor.getChangedInputs() + " " + IOMonitor.getChangedOutputs());
        if (IOMonitor.getChangedInputs() != 0) {
            this.sendChangedInputTraps();
        }
        if (IOMonitor.getChangedOutputs() != 0) {
            this.sendChangedOutputTraps();
        }
    }

    @Override
    public void run() throws InterruptedException {
        while (true) {
            super.feedWatchdog();
            Thread.sleep(30000L);
        }
    }

    private void sendChangedInputTraps() {
        int input = 1;
        String regTrapConfigKey = "IO/Inputs/SnmpTrapMask";
        int trapConfigMask = JANOS.getRegistryInt((String)regTrapConfigKey, (int)0);
        int changedInputs = IOMonitor.getChangedInputs();
        while (changedInputs > 0) {
            if ((changedInputs & 1) != 0) {
                regTrapConfigKey = "IO/Inputs/din" + input + "/SnmpTrap";
                boolean enabled = JANOS.getRegistryBoolean((String)regTrapConfigKey, (boolean)false);
                if (enabled |= (trapConfigMask & 1) == 1) {
                    this._trapSender.sendTrap(new SNMPObjectIdentifier("1.3.6.1.4.1.31976.1.1.2.1.2." + input), SNMPStore.SYSTEM_INPUTS[input - 1], "public");
                }
            }
            ++input;
            changedInputs >>= 1;
            trapConfigMask >>= 1;
        }
    }

    private void sendChangedOutputTraps() {
        int output = 1;
        String regTrapConfigKey = "IO/Outputs/SnmpTrapMask";
        int trapConfigMask = JANOS.getRegistryInt((String)regTrapConfigKey, (int)0);
        int changedOutputs = IOMonitor.getChangedOutputs();
        while (changedOutputs > 0) {
            if ((changedOutputs & 1) != 0) {
                regTrapConfigKey = "IO/Outputs/rout" + output + "/SnmpTrap";
                boolean enabled = JANOS.getRegistryBoolean((String)regTrapConfigKey, (boolean)false);
                if (enabled |= (trapConfigMask & 1) == 1) {
                    this._trapSender.sendTrap(new SNMPObjectIdentifier("1.3.6.1.4.1.31976.1.1.4.1.2." + output), SNMPStore.SYSTEM_OUTPUTS[output - 1], "public");
                }
            }
            ++output;
            changedOutputs >>= 1;
            trapConfigMask >>= 1;
        }
    }

    private void sendBootCompleteTrap() {
        this._trapSender.sendTrap(new SNMPObjectIdentifier("1.3.6.1.4.1.31976.1.0.1"), new SNMPOctetString(JANOS.getSerialNumber() + "; Boot Complete (" + JANOS.getPOR() + ")"), "public");
    }

    @Override
    public void processGetRequest(SNMPRequestPDU pdu) throws Exception {
        SNMPVarBindings varBindings = pdu.getVarBindings();
        Vector<SNMPVariablePair> pairs = varBindings.getVariablePairs();
        for (int i = 0; i < pairs.size(); ++i) {
            try {
                SNMPVariablePair pair = pairs.elementAt(i);
                SNMPObjectIdentifier oid = pair.getOID();
                SNMPVariablePair foundPair = SNMPStore.findPair(oid);
                if (null == foundPair) {
                    pdu.setErrorIndex(i + 1);
                    pdu.setErrorStatus(2);
                    break;
                }
                pair.setObject(foundPair.getObject());
                continue;
            }
            catch (SNMPBadValueException ex) {
                AppLog.error(ex);
            }
        }
    }

    @Override
    public void processGetNextRequest(SNMPRequestPDU pdu) throws Exception {
        SNMPVarBindings varBindings = pdu.getVarBindings();
        Vector<SNMPVariablePair> pairs = varBindings.getVariablePairs();
        for (int i = 0; i < pairs.size(); ++i) {
            try {
                SNMPVariablePair pair = pairs.elementAt(i);
                SNMPObjectIdentifier oid = pair.getOID();
                SNMPVariablePair foundPair = SNMPStore.findNextPair(oid);
                if (null == foundPair) {
                    pdu.setErrorIndex(i + 1);
                    pdu.setErrorStatus(2);
                    break;
                }
                varBindings.setPairAt(foundPair, i);
                continue;
            }
            catch (SNMPBadValueException ex) {
                AppLog.error(ex);
            }
        }
    }
}

