/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.snmp.AgentInterface;
import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPMessage;
import com.integpg.snmp.objects.SNMPRequestPDU;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class Agent
implements Runnable {
    public static final int SNMP_PORT = 161;
    private static final int RECEIVE_BUFFER_SIZE = 512;
    private DatagramSocket _datagramSocket;
    private Thread _receiveThread;
    private AgentInterface _agentInterface = null;

    public Agent() {
        try {
            this._datagramSocket = new DatagramSocket(161);
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
    }

    public void setAgentInterface(AgentInterface agentInterface) {
        this._agentInterface = agentInterface;
    }

    public void listen() {
        if (null == this._receiveThread) {
            this._receiveThread = new Thread(this);
            this._receiveThread.setDaemon(true);
            this._receiveThread.start();
        }
    }

    @Override
    public void run() {
        AppLog.info("agent listening on port 161");
        while (!this._receiveThread.isInterrupted()) {
            try {
                DatagramPacket inPacket = new DatagramPacket(new byte[512], 512);
                this._datagramSocket.receive(inPacket);
                InetAddress requesterAddress = inPacket.getAddress();
                int requesterPort = inPacket.getPort();
                byte[] messageBytes = inPacket.getData();
                ByteArrayInputStream bain = new ByteArrayInputStream(messageBytes);
                SNMPCodec codec = new SNMPCodec(bain);
                int tag = codec.read();
                if (48 != tag) {
                    throw new RuntimeException("SNMP Sequence Expected");
                }
                SNMPMessage message = new SNMPMessage();
                message.decodeBER(codec);
                SNMPRequestPDU pdu = (SNMPRequestPDU)message.getPDU();
                if (null != this._agentInterface) {
                    switch (pdu.getTag()) {
                        case 160: {
                            this._agentInterface.processGetRequest(pdu);
                            break;
                        }
                        case 161: {
                            this._agentInterface.processGetNextRequest(pdu);
                        }
                    }
                }
                pdu.setResponse();
                ByteArrayOutputStream baout = new ByteArrayOutputStream();
                SNMPCodec outCodec = new SNMPCodec(baout);
                message.encodeBER(outCodec);
                byte[] outBytes = baout.toByteArray();
                DatagramPacket outPacket = new DatagramPacket(outBytes, outBytes.length, requesterAddress, requesterPort);
                this._datagramSocket.send(outPacket);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

