/*
 * Decompiled with CFR 0.152.
 */
package com.integ.slaveservice;

import com.integ.slaveservice.AssemblyInfo;
import com.integ.slaveservice.SlaveService;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.ArrayList;

public class LocalSlaveService
extends SlaveService {
    private static final LocalSlaveService INSTANCE = new LocalSlaveService();

    public static LocalSlaveService getInstance() {
        return INSTANCE;
    }

    private LocalSlaveService() {
        this._log = Logger.getLogger(AssemblyInfo.getName() + "_localhost.log");
    }

    @Override
    protected synchronized void monitor() {
        AppLog.info("Starting Local Slave Service");
        if (null == this._monitorThread) {
            this._monitorThread = new Thread(this);
            this._monitorThread.setDaemon(true);
            this._monitorThread.setName(this.getClass().getName() + ":localhost");
            this._monitorThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AppLog.info("Local Slave Service has started");
        this._running = true;
        while (this._running) {
            int usedOutputMask = 0;
            int newOutputs = 0;
            int remoteInputs = JANOS.getInputStates();
            int remoteOutputs = JANOS.getOutputStates();
            ArrayList arrayList = this._rules;
            synchronized (arrayList) {
                for (int i = 0; i < this._rules.size(); ++i) {
                    SlaveService.Rule rule = (SlaveService.Rule)this._rules.get(i);
                    int state = 0;
                    int remoteChannel = rule.RemoteIoChannel;
                    state = 0 == rule.RemoteIoType ? remoteInputs >> remoteChannel - 1 & 1 : remoteOutputs >> remoteChannel - 1 & 1;
                    if (rule.Invert) {
                        state = (state + 1) % 2;
                    }
                    int localChannel = rule.LocalIoChannel;
                    if (0 == rule.LocalIoType) {
                        JANOS.setInputConditioning((int)(localChannel - 1), (int)(1 == state ? 3 : 2));
                        continue;
                    }
                    usedOutputMask |= 1 << localChannel - 1;
                    newOutputs |= state << localChannel - 1;
                }
            }
            try {
                JANOS.setOutputStates((int)newOutputs, (int)usedOutputMask);
            }
            catch (IOException ex) {
                this._log.error(ex);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        AppLog.info("Local Slave Service has stopped");
    }
}

