/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integpg.janoslib.messaging.CustomMessageListener;
import com.integpg.snmp.TrapSender;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPNull;
import com.integpg.snmp.objects.SNMPObject;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.system.SystemMsg;
import java.util.Json;

class TrapReceiveHandler
implements CustomMessageListener {
    private final TrapSender _trapSender;

    public TrapReceiveHandler(TrapSender trapSender) {
        this._trapSender = trapSender;
    }

    @Override
    public void messageReceived(SystemMsg msg) {
        Json json = new Json(new String(msg.msg));
        System.out.println("msg: " + msg.type + " = " + json);
        String id = (String)json.get("oid");
        String type = (String)json.get("type");
        String value = (String)json.get("value");
        SNMPObject object = new SNMPNull();
        if ("string".equalsIgnoreCase(type)) {
            object = new SNMPOctetString(value);
        } else if ("integer".equalsIgnoreCase(type)) {
            object = new SNMPInteger(Integer.parseInt(value));
        }
        SNMPObjectIdentifier oid = new SNMPObjectIdentifier(id);
        this._trapSender.sendTrap(oid, object, "public");
    }
}

