/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.utils;

import java.io.ByteArrayOutputStream;

public class HexUtils {
    public static final char[] HexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] LowerHexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String bytesToHex(byte[] bytes) {
        if (null == bytes) {
            return "null";
        }
        return HexUtils.bytesToHex(bytes, 0, bytes.length);
    }

    public static String bytesToHex(byte[] bytes, int offset, int len) {
        if (null == bytes) {
            return "null";
        }
        char[] hexChars = new char[len * 2];
        int i = 0;
        for (int j = offset; j < offset + len; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[i++] = HexArray[v >> 4 & 0xF];
            hexChars[i++] = HexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexToBytes(String hexString) {
        return HexUtils.hexToBytes(hexString, 0, hexString.length(), 2);
    }

    public static byte[] hexToBytes(String hexString, int offset, int len) {
        return HexUtils.hexToBytes(hexString, offset, len, 2);
    }

    public static byte[] hexToBytes(String hexString, int offset, int len, int charsPerByte) {
        if (null == hexString) {
            return new byte[0];
        }
        byte[] bytes = new byte[len / charsPerByte];
        int i = 0;
        for (int j = offset; j < len; j += charsPerByte) {
            char c = hexString.charAt(j);
            int n = 0;
            if ('0' <= c && '9' >= c) {
                n = c - 48;
            } else if ('A' <= c && 'F' >= c) {
                n = c - 55;
            } else if ('a' <= c && 'f' >= c) {
                n = c - 87;
            } else {
                throw new RuntimeException("error parsing hex");
            }
            int val = n << 4;
            c = hexString.charAt(j + 1);
            n = 0;
            if ('0' <= c && '9' >= c) {
                n = c - 48;
            } else if ('A' <= c && 'F' >= c) {
                n = c - 55;
            } else if ('a' <= c && 'f' >= c) {
                n = c - 87;
            } else {
                throw new RuntimeException("error parsing hex");
            }
            bytes[i++] = (byte)(val += n);
        }
        return bytes;
    }

    public static String hexDump(byte[] bytes) {
        return HexUtils.hexDump(bytes, 0, bytes.length);
    }

    public static String hexDump(byte[] bytes, int offset, int length) {
        StringBuilder sb = new StringBuilder((length / 16 + 1) * 83);
        char[] line = new char[81];
        line[0] = 48;
        line[1] = 120;
        line[line.length - 2] = 13;
        line[line.length - 1] = 10;
        int endAddress = offset + length;
        for (int lineAddress = offset - offset % 16; lineAddress < endAddress; lineAddress += 16) {
            char c;
            int address;
            int linePos;
            int charPos = 2;
            line[charPos++] = LowerHexArray[lineAddress >> 12 & 0xF];
            line[charPos++] = LowerHexArray[lineAddress >> 8 & 0xF];
            line[charPos++] = LowerHexArray[lineAddress >> 4 & 0xF];
            line[charPos++] = LowerHexArray[lineAddress & 0xF];
            line[charPos++] = 32;
            line[charPos++] = 32;
            line[charPos++] = 32;
            for (linePos = 0; linePos < 16; ++linePos) {
                address = lineAddress + linePos;
                if (address < offset) {
                    line[charPos++] = 32;
                    line[charPos++] = 32;
                    line[charPos++] = 32;
                } else if (address < endAddress) {
                    c = bytes[address];
                    line[charPos++] = LowerHexArray[c >> 4 & 0xF];
                    line[charPos++] = LowerHexArray[c & 0xF];
                    line[charPos++] = 32;
                } else {
                    line[charPos++] = 32;
                    line[charPos++] = 32;
                    line[charPos++] = 32;
                }
                if (7 != linePos) continue;
                line[charPos++] = 32;
                line[charPos++] = 32;
            }
            line[charPos++] = 32;
            line[charPos++] = 32;
            line[charPos++] = 32;
            for (linePos = 0; linePos < 16; ++linePos) {
                address = lineAddress + linePos;
                line[charPos++] = address < offset ? 32 : (address < endAddress ? (' ' > (c = (char)bytes[address]) || '\u0080' <= c ? 46 : c) : 32);
                if (7 != linePos) continue;
                line[charPos++] = 32;
            }
            sb.append(line, 0, line.length);
        }
        return sb.toString();
    }

    public static long parseHexAsLong(String s) {
        if (s == null) {
            return 0L;
        }
        int len = s.length();
        long l = Long.parseLong(s.substring(0, len - 8), 16);
        l <<= 32;
        return l += Long.parseLong(s.substring(len - 8), 16);
    }

    public static byte[] unescapeString(String escapedString) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        System.out.println("unescape: " + escapedString);
        boolean backslashFound = false;
        for (int i = 0; i < escapedString.length(); ++i) {
            if (escapedString.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
                continue;
            }
            if (backslashFound) {
                switch (escapedString.charAt(i)) {
                    case 'r': {
                        byteArrayOutputStream.write(13);
                        break;
                    }
                    case 'n': {
                        byteArrayOutputStream.write(10);
                        break;
                    }
                    case 't': {
                        byteArrayOutputStream.write(9);
                        break;
                    }
                    case 'f': {
                        byteArrayOutputStream.write(12);
                        break;
                    }
                    case 'b': {
                        byteArrayOutputStream.write(8);
                        break;
                    }
                    case '0': {
                        byteArrayOutputStream.write(0);
                        break;
                    }
                    case 'x': {
                        String s = escapedString.substring(i + 1, i + 3);
                        i += 2;
                        byteArrayOutputStream.write((char)Integer.parseInt(s, 16));
                    }
                }
            } else {
                byteArrayOutputStream.write(escapedString.charAt(i));
            }
            backslashFound = false;
        }
        System.out.println("-- byteArrayOutputStream [" + byteArrayOutputStream.size() + "]:\r\n" + HexUtils.bytesToHex(byteArrayOutputStream.toByteArray()));
        return byteArrayOutputStream.toByteArray();
    }
}

