/*
 * Decompiled with CFR 0.152.
 */
package com.integ.serialcontrol;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.system.JANOS;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Jrmon {
    public static byte[] parseCommand(String lowerCommand) throws IOException {
        if (0 <= (lowerCommand = lowerCommand.toLowerCase()).indexOf(",")) {
            int begin = 0;
            while (begin >= 0) {
                int end = lowerCommand.indexOf(",", begin + 1);
                Jrmon.parseCommand(lowerCommand, begin, end);
                if (end >= 0) {
                    // empty if block
                }
                begin = ++end;
            }
        } else {
            return Jrmon.parseCommand(lowerCommand, 0, lowerCommand.length());
        }
        return null;
    }

    public static byte[] parseCommand(String lowerCommand, int beginIndex, int endIndex) throws IOException {
        int currentStates;
        if (endIndex == -1) {
            endIndex = lowerCommand.length();
        }
        lowerCommand = lowerCommand.substring(beginIndex, endIndex);
        AppLog.info("process: " + lowerCommand);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int states = 0;
        int mask = 0;
        int parameter = 1000;
        boolean close = false;
        boolean open = false;
        boolean toggle = false;
        boolean reset = false;
        boolean setcounters = false;
        boolean dosetcounters = false;
        boolean pulse = false;
        boolean value = false;
        boolean stop = false;
        int shift = 0;
        int len = lowerCommand.length();
        char[] chars = new char[len];
        lowerCommand.getChars(0, len, chars, 0);
        states = currentStates = JANOS.getOutputStates();
        block12: for (int i = 0; i < len && !stop; ++i) {
            switch (chars[i]) {
                case 'c': {
                    close = true;
                    open = false;
                    toggle = false;
                    reset = false;
                    setcounters = false;
                    continue block12;
                }
                case 'o': {
                    open = true;
                    close = false;
                    toggle = false;
                    reset = false;
                    setcounters = false;
                    continue block12;
                }
                case 't': {
                    open = false;
                    close = false;
                    toggle = true;
                    reset = false;
                    setcounters = false;
                    continue block12;
                }
                case 'p': {
                    pulse = true;
                    continue block12;
                }
                case '=': {
                    char c;
                    int n;
                    StringBuffer sb = new StringBuffer();
                    for (n = i + 1; n < lowerCommand.length() && Character.isDigit(c = lowerCommand.charAt(n)); ++n) {
                        sb.append(c);
                        ++i;
                    }
                    String cmd = sb.toString();
                    for (n = 0; n < cmd.length(); ++n) {
                        if (Character.isDigit(cmd.charAt(n))) continue;
                        return null;
                    }
                    parameter = new Integer(cmd);
                    value = true;
                    continue block12;
                }
                case 's': {
                    dosetcounters = true;
                    setcounters = true;
                    open = false;
                    close = false;
                    toggle = false;
                    reset = false;
                    continue block12;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': {
                    if (!(open || close || toggle || reset || setcounters)) {
                        return null;
                    }
                    int n = lowerCommand.charAt(i) - 49;
                    if (shift == 0) {
                        mask |= 1 << n;
                        if (close) {
                            states |= 1 << n;
                        } else if (open) {
                            states &= ~(1 << n);
                        } else if (toggle) {
                            states ^= 1 << n;
                        }
                    } else {
                        mask |= 1 << n + 8 * shift;
                        if (close) {
                            states |= 1 << n << 8 * shift;
                        } else if (open) {
                            states &= ~(1 << n << 8 * shift);
                        } else if (toggle) {
                            states ^= 1 << n << 8 * shift;
                        }
                    }
                    shift = 0;
                    continue block12;
                }
                case '+': {
                    ++shift;
                    continue block12;
                }
                case '*': {
                    if (!(open || close || reset || setcounters)) {
                        return null;
                    }
                    mask = (int)((long)mask | 0xFFFFFFFFL);
                    if (close) {
                        states = -1;
                        continue block12;
                    }
                    if (!open) continue block12;
                    states = 0;
                    continue block12;
                }
                case ' ': {
                    continue block12;
                }
            }
        }
        if (value && !pulse && !dosetcounters) {
            return null;
        }
        if (value && pulse && dosetcounters) {
            return null;
        }
        if (dosetcounters && !value) {
            return null;
        }
        if (mask != 0) {
            if (pulse) {
                if (dos != null) {
                    dos.writeByte(1);
                    dos.writeShort((short)mask);
                    dos.writeShort((short)states);
                    dos.writeInt(parameter);
                    JANOS.setOutputPulsed((int)states, (int)mask, (int)parameter);
                }
            } else if (!toggle) {
                if (dos != null) {
                    dos.writeByte(2);
                    dos.writeShort((short)mask);
                    dos.writeShort((short)states);
                }
                JANOS.setOutputStates((int)states, (int)mask);
            } else if (toggle) {
                baos = new ByteArrayOutputStream();
                dos = new DataOutputStream(baos);
                JANOS.setOutputStates((int)states, (int)mask);
            }
        }
        return baos.toByteArray();
    }
}

