/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPInteger;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.snmp.objects.SNMPPDU;
import com.integpg.snmp.objects.SNMPSequence;
import java.io.IOException;

public class SNMPMessage
extends SNMPSequence {
    private SNMPInteger _version;
    private SNMPOctetString _community;
    private SNMPPDU _pdu;

    public SNMPMessage() {
    }

    public SNMPMessage(SNMPInteger version, SNMPOctetString community, SNMPPDU pdu) {
        this._version = version;
        this._community = community;
        this._pdu = pdu;
    }

    @Override
    public void decodeBER(SNMPCodec codec) throws IOException {
        super.decodeBER(codec);
        this._version = (SNMPInteger)codec.getNextSnmpObject();
        this._community = (SNMPOctetString)codec.getNextSnmpObject();
        this._pdu = (SNMPPDU)codec.getNextSnmpObject();
    }

    public SNMPInteger getVersion() {
        return this._version;
    }

    public SNMPOctetString getCommunity() {
        return this._community;
    }

    public SNMPPDU getPDU() {
        return this._pdu;
    }

    @Override
    public void encodeBER(SNMPCodec codec) throws IOException {
        super.encodeBER(codec);
        this.getVersion().encodeBER(codec);
        this.getCommunity().encodeBER(codec);
        this.getPDU().encodeBER(codec);
    }

    @Override
    public int getLength() {
        int totalLength;
        this._length = totalLength = this.getVersion().getTLVLength() + this.getCommunity().getTLVLength() + this.getPDU().getTLVLength();
        return this._length;
    }

    @Override
    public String toString() {
        return "SNMP Message: \r\n   version: " + this.getVersion() + "\r\n   error: " + this.getCommunity() + "\r\n   pdu: " + this.getPDU();
    }
}

