/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets.websockethandlers;

import com.integ.janoslib.messagepump.MessagePumpAppMessageListener;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integpg.analogpresets.AnalogPresetsMain;
import com.integpg.analogpresets.configuration.Config;
import com.integpg.analogpresets.websockethandlers.ConfigResponseMessage;
import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.Json;

public class GetConfigHandler
implements MessagePumpAppMessageListener {
    @Override
    public void applicationMessageReceived(Json commandJson) {
        try {
            Json devicesJson = new Json();
            devicesJson.put("FourTwentyPresent", (Object)this.devicesExist(AnalogPresetsMain._feDevices));
            devicesJson.put("TenVoltPresent", (Object)this.devicesExist(AnalogPresetsMain._fdDevices));
            devicesJson.put("ThreeChannelLEDPresent", (Object)this.devicesExist(AnalogPresetsMain._f9Devices));
            ConfigResponseMessage configResponseMessage = new ConfigResponseMessage(Config.getJson(), devicesJson);
            System.out.println("configResponseMessage = " + (Object)((Object)configResponseMessage));
            MessagePumpEngine.postMessage(configResponseMessage.build());
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
    }

    private boolean devicesExist(ExternalModule[] deviceArray) throws IOException {
        boolean exists = false;
        long[] connectedDevices = JANOS.getExternalDeviceList();
        if (deviceArray.length > 0 && connectedDevices.length > 0) {
            for (int i = 0; i < deviceArray.length; ++i) {
                ExternalModule module = deviceArray[i];
                if (null == module) continue;
                for (int j = 0; j < connectedDevices.length; ++j) {
                    if (module.Address != connectedDevices[j]) continue;
                    return true;
                }
            }
        }
        return exists;
    }
}

