/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.sensor.SensorPort;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.Hashtable;

public abstract class ExternalModule {
    private static final String EXTERNAL_DEVICEORDER_REGISTRY_STRING = "Externals/DeviceOrder";
    protected static final SensorPort SENSOR_PORT = new SensorPort();
    protected static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("yyyy-MM-dd HH:mm:ss zzz");
    public long Address;
    public String AddressString;
    public int TypeIndex;
    public String TypeString;
    public long LastReadTime;
    public long LastWriteTime;
    protected byte[] _dataBlock;
    protected static String[] _externalDevices;
    protected static final Hashtable<String, ExternalModule> ModulesByAddress;

    protected static long getDeviceAddressForDeviceString(String deviceTypeIndex) {
        String addressString = JANOS.getRegistryString((String)String.format("%s/%s", EXTERNAL_DEVICEORDER_REGISTRY_STRING, deviceTypeIndex), (String)"");
        System.out.println("addressString = " + addressString);
        int len = addressString.length();
        long address = Long.parseLong(addressString.substring(0, len - 8), 16);
        address <<= 32;
        return address += Long.parseLong(addressString.substring(len - 8), 16);
    }

    protected static int getIndexForAddress(long address) {
        String[] externalDeviceOrderKeys;
        for (String externalDeviceKey : externalDeviceOrderKeys = JANOS.getRegistryList((String)EXTERNAL_DEVICEORDER_REGISTRY_STRING)) {
            System.out.println("externalDeviceKey = " + externalDeviceKey);
        }
        return 0;
    }

    public ExternalModule(long address, int index, String typeString) {
        this.setAddress(address);
        System.out.println(this.Address + " index = " + index);
        if (0 > index) {
            index = ExternalModule.getIndexForAddress(address);
            System.out.println(this.Address + " index is now " + index);
        }
        this.TypeIndex = index;
        this.TypeString = typeString + "_" + index;
    }

    private void setAddress(long address) {
        this.Address = address;
        this.AddressString = "0000000000000000" + Long.toHexString(address);
        this.AddressString = this.AddressString.substring(this.AddressString.length() - 16);
        this.AddressString = this.AddressString.toUpperCase();
    }

    public long getMinReadInterval() {
        return 0L;
    }

    public abstract void read() throws Throwable;

    public abstract void commit() throws IOException;

    public byte[] getDataBlock() {
        return this._dataBlock;
    }

    public abstract void printValues();

    public float scaleValue(int raw, double min, double max) {
        double percent = (double)raw / 65535.0;
        return (float)(percent * (max - min) + min);
    }

    public abstract Object get(String var1);

    static {
        ModulesByAddress = new Hashtable();
    }
}

