/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.iomonitor;

import com.integpg.iomonitor.IOChangeListener;
import com.integpg.system.JANOS;
import java.util.Vector;

public class IOMonitor
implements Runnable {
    private static final IOMonitor _instance = new IOMonitor();
    private Thread _thd;
    private final Vector _listeners = new Vector();
    private long lastIoSignature = JANOS.getIoSignature();
    private int lastInputStates = JANOS.getInputStates();
    private int lastOutputStates = JANOS.getOutputStates();
    public static int InputStates;
    public static int ChangedInputMask;
    public static int OutputStates;
    public static int ChangedOutputMask;
    private final int[] _lastInputCounters = new int[12];

    private IOMonitor() {
        for (int i = 0; i < 12; ++i) {
            this._lastInputCounters[i] = JANOS.getInputCounter((int)i);
        }
    }

    public static void addListener(IOChangeListener listener) {
        IOMonitor._instance._listeners.addElement(listener);
    }

    public static void startMonitoring() {
        _instance.start();
    }

    private void start() {
        if (this._thd == null) {
            this._thd = new Thread(this);
            this._thd.setName("IO Monitor");
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    @Override
    public void run() {
        System.out.println("IO Monitor active");
        while (true) {
            try {
                while (true) {
                    this.checkIO();
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void checkIO() {
        if (this.hasIOChanged()) {
            this.checkInputs();
            this.checkOutputs();
            this.alertListeners();
        }
    }

    private void checkInputs() {
        int changedInputMask = 0;
        for (int i = 0; i < 12; ++i) {
            int inputCounter = JANOS.getInputCounter((int)i);
            if (inputCounter == this._lastInputCounters[i]) continue;
            this._lastInputCounters[i] = inputCounter;
            changedInputMask |= 1 << i;
        }
        InputStates = JANOS.getInputStates();
        ChangedInputMask = changedInputMask | InputStates ^ this.lastInputStates;
        this.lastInputStates = InputStates;
    }

    private void checkOutputs() {
        OutputStates = JANOS.getOutputStates();
        ChangedOutputMask = OutputStates ^ this.lastOutputStates;
        this.lastOutputStates = OutputStates;
    }

    private boolean hasIOChanged() {
        long ioSignature = JANOS.getIoSignature();
        boolean hasChanged = ioSignature != this.lastIoSignature;
        this.lastIoSignature = ioSignature;
        return hasChanged;
    }

    private void alertListeners() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            IOChangeListener listener = (IOChangeListener)this._listeners.elementAt(i);
            if (ChangedInputMask != 0) {
                listener.inputsChanged();
            }
            if (ChangedOutputMask == 0) continue;
            listener.outputsChanged();
        }
    }
}

