/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messaging.websocket;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.messaging.websocket.PingHandler;
import com.integpg.janoslib.messaging.websocket.WebsocketClientInformation;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageEventObject;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageHandler;
import com.integpg.janoslib.messaging.websocket.WebsocketServer;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.User;
import java.util.Hashtable;
import java.util.Json;

public class LoginHandler
extends WebsocketMessageHandler {
    public LoginHandler() {
        super(null);
    }

    @Override
    public String getMessage() {
        return "login";
    }

    @Override
    public void handleMessage(WebsocketMessageEventObject eventObject) throws Exception {
        Json jsonResp;
        String password;
        String username;
        WebsocketServer websocketServer = eventObject.getWebsocketServer();
        WebsocketClientInformation clientInformation = eventObject.getClientInformation();
        Json json = eventObject.getJson();
        int msgId = eventObject.getMsgId();
        AppLog.info(clientInformation.getClientString() + " logging in");
        Hashtable loggedInClients = websocketServer.getLoggedInClients();
        if (json.get("Credentials") != null) {
            String credentials = (String)json.get("Credentials");
            String[] loginParts = StringUtils.split(credentials, ":");
            username = loginParts[0];
            password = loginParts[1];
        } else {
            username = (String)json.get("Username");
            password = (String)json.get("Password");
        }
        int userId = User.validate((String)username, (String)password);
        System.out.println("user id: " + userId);
        if (userId > 0) {
            loggedInClients.put(clientInformation.getClientString(), new Integer(userId));
            jsonResp = new Json("{\"Message\":\"Authenticated\"}");
            websocketServer.sendToWebsocket(clientInformation, jsonResp, msgId);
            PingHandler pingHandler = (PingHandler)websocketServer.getWebsocketMessageHandler("ping");
            pingHandler.handleMessage(eventObject);
        } else {
            jsonResp = new Json("{\"Message\":\"Error\", \"Text\":\"Login Failed\"}");
            websocketServer.sendToWebsocket(clientInformation, jsonResp, msgId);
        }
    }
}

