/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets.websockethandlers;

import com.integpg.analogpresets.AnalogPresetsMain;
import com.integpg.analogpresets.configuration.Config;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.messaging.websocket.WebsocketClientInformation;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageEventObject;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageHandler;
import com.integpg.janoslib.messaging.websocket.WebsocketServer;
import java.util.Json;

public class SaveConfigHandler
extends WebsocketMessageHandler {
    public SaveConfigHandler(Object parent) {
        super(parent);
    }

    @Override
    public String getMessage() {
        return "save-config";
    }

    @Override
    public void handleMessage(WebsocketMessageEventObject eventObject) throws Exception {
        AnalogPresetsMain parent = (AnalogPresetsMain)this._parent;
        WebsocketServer websocketServer = eventObject.getWebsocketServer();
        WebsocketClientInformation clientInformation = eventObject.getClientInformation();
        Json json = eventObject.getJson();
        int msgId = eventObject.getMsgId();
        AppLog.info(clientInformation.getClientString() + " saving label configuration");
        try {
            Json configJson = (Json)json.get("Config");
            Config.saveConfig(configJson);
            WebsocketMessageHandler getConfigHandler = websocketServer.getWebsocketMessageHandler("get-config");
            getConfigHandler.handleMessage(eventObject);
        }
        catch (Exception ex) {
            AppLog.error("Error saving part configuration");
        }
    }
}

