/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets.configuration;

import com.integpg.analogpresets.FourTwentyTransition;
import com.integpg.analogpresets.Level;
import com.integpg.analogpresets.TenVoltTransition;
import com.integpg.analogpresets.ThreeChannelLedTransition;
import com.integpg.analogpresets.TriggerPointConfig;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.ObjectUtils;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.JANOS;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Json;

public class Config {
    public static String RegistryRoot = "AppData/AnalogPresets";
    private static Json _json;
    public static int GlobalTransitionTime;
    public static Hashtable ConfiguredLevels;

    public static void loadConfiguration() {
        try {
            String[] registryKeys = JANOS.getRegistryList((String)RegistryRoot);
            if (registryKeys.length > 0) {
                Config.upgradeOldStaticLevelConfiguration();
                Config.upgradeConfig(true);
            }
            long start = JANOS.uptimeMillis();
            _json = new Json(new File("flash/analogpresets.json"));
            long elapsed = JANOS.uptimeMillis() - start;
            System.out.println(" load json elapsed: " + elapsed);
            Config.processConfiguration();
        }
        catch (Exception ex) {
            AppLog.error("Error loading configuration", ex);
        }
    }

    public static Json getJson() {
        return _json;
    }

    private static void upgradeOldStaticLevelConfiguration() {
        boolean upgradeNeeded = true;
        String[] oldRegistryFolders = JANOS.getRegistryList((String)RegistryRoot);
        System.out.println(oldRegistryFolders.length);
        for (int i = 0; i < oldRegistryFolders.length; ++i) {
            if (!oldRegistryFolders[i].endsWith("/") || !oldRegistryFolders[i].startsWith("Level_")) continue;
            if (upgradeNeeded) {
                JANOS.execute((String)"registry -s", null, null, null, null, (boolean)true);
            }
            upgradeNeeded = false;
            System.out.println("  " + oldRegistryFolders[i]);
            String f = RegistryRoot + "/" + oldRegistryFolders[i].substring(0, oldRegistryFolders[i].length() - 1);
            System.out.println("get list for " + f);
            String[] keys = JANOS.getRegistryList((String)f);
            System.out.println(keys.length);
            for (int j = 0; j < keys.length; ++j) {
                String oldKey = f + "/" + keys[j];
                String newKey = RegistryRoot + "/LevelSettings/" + oldRegistryFolders[i] + keys[j];
                String oldValue = JANOS.getRegistryString((String)oldKey, (String)"");
                System.out.println("  " + oldKey + " = " + oldValue + " -> " + newKey);
                JANOS.setRegistryString((String)newKey, (String)oldValue);
                System.out.println("  remove " + oldKey);
                JANOS.setRegistryString((String)oldKey, (String)"");
            }
        }
        JANOS.setRegistryString((String)(RegistryRoot + "/Levels"), (String)"");
    }

    private static void upgradeConfig(boolean eraseRegistryKeys) {
        try {
            AppLog.info("Upgrading configuration from registry");
            Json json = new Json();
            json.put("GlobalTransitionTime", (Object)JANOS.getRegistryString((String)(RegistryRoot + "/GlobalTransitionTime"), (String)""));
            if (eraseRegistryKeys) {
                JANOS.setRegistryString((String)(RegistryRoot + "/GlobalTransitionTime"), (String)"");
            }
            Json clientJson = new Json();
            clientJson.put("TcpServerPort", (Object)JANOS.getRegistryString((String)(RegistryRoot + "/Client/TcpServerPort"), (String)""));
            clientJson.put("TerminationString", (Object)JANOS.getRegistryString((String)(RegistryRoot + "/Client/TerminationString"), (String)""));
            if (eraseRegistryKeys) {
                JANOS.setRegistryString((String)(RegistryRoot + "/Client/TcpServerPort"), (String)"");
            }
            if (eraseRegistryKeys) {
                JANOS.setRegistryString((String)(RegistryRoot + "/Client/TerminationString"), (String)"");
            }
            json.put("Client", (Object)clientJson);
            String[] levelFolders = JANOS.getRegistryList((String)(RegistryRoot + "/LevelSettings"));
            Json[] levelsJson = new Json[levelFolders.length];
            for (int i = 0; i < levelFolders.length; ++i) {
                String levelName = levelFolders[i];
                if (levelName.endsWith("/")) {
                    levelName = levelName.substring(0, levelName.length() - 1);
                }
                System.out.println(levelName);
                Json levelJson = new Json();
                String[] levelKeys = JANOS.getRegistryList((String)(RegistryRoot + "/LevelSettings/" + levelFolders[i].substring(0, levelFolders[i].length() - 1)));
                levelJson.put("Name", (Object)levelName);
                for (int j = 0; j < levelKeys.length; ++j) {
                    System.out.println("  " + levelKeys[j]);
                    levelJson.put(levelKeys[j], (Object)JANOS.getRegistryString((String)(RegistryRoot + "/LevelSettings/" + levelFolders[i] + levelKeys[j]), (String)""));
                    if (!eraseRegistryKeys) continue;
                    JANOS.setRegistryString((String)(RegistryRoot + "/LevelSettings/" + levelFolders[i] + levelKeys[j]), (String)"");
                }
                levelsJson[i] = levelJson;
            }
            json.put("LevelSettings", (Object)levelsJson);
            System.out.println(json);
        }
        catch (Exception ex) {
            AppLog.error("Error upgrading configuration from the registry", ex);
        }
    }

    public static void saveConfig(Json json) throws IOException {
        _json = json;
        long start = JANOS.uptimeMillis();
        json.save(new File("flash/analogpresets.json"));
        long elapsed = JANOS.uptimeMillis() - start;
        System.out.println(" save json elapsed: " + elapsed);
        Config.processConfiguration();
    }

    private static void getDefaultGlobalTransitionTime() {
        System.out.print("Read default global transition time: ");
        GlobalTransitionTime = ObjectUtils.getInt(_json.get("GlobalTransitionTime"), 5000);
        System.out.println(String.valueOf(GlobalTransitionTime));
    }

    private static Json loadLevelSettings(Json levelSettingJson) {
        if (null == levelSettingJson) {
            return null;
        }
        System.out.println("Level Setting Json: " + levelSettingJson);
        String levelSettingName = ObjectUtils.getString(levelSettingJson.get("Name"), "");
        if (levelSettingName.endsWith("/")) {
            levelSettingName = levelSettingName.substring(0, levelSettingName.length() - 1);
            levelSettingJson.put("Name", (Object)levelSettingName);
        }
        try {
            TriggerPointConfig triggerPointConfig = Config.getTriggerPointConfig(levelSettingJson);
            Level level = new Level(triggerPointConfig);
            ConfiguredLevels.put(triggerPointConfig.Name, level);
            ThreeChannelLedTransition threeChannelLedTransition = Config.loadThreeChannel(triggerPointConfig, levelSettingJson);
            System.out.println("threeChannelLedTransition: " + threeChannelLedTransition);
            if (threeChannelLedTransition != null) {
                level.setThreeChannelLedTranstion(threeChannelLedTransition);
            }
            FourTwentyTransition fourTwentyTransition = Config.loadFourTwentyChannel(triggerPointConfig, levelSettingJson);
            System.out.println("fourTwentyTransition: " + fourTwentyTransition);
            if (fourTwentyTransition != null) {
                level.setFourTwentyTranstion(fourTwentyTransition);
            }
            TenVoltTransition tenVoltTransition = Config.loadTenVoltChannel(triggerPointConfig, levelSettingJson);
            System.out.println("tenVoltTransition: " + tenVoltTransition);
            if (tenVoltTransition != null) {
                level.setTenVoltTranstion(tenVoltTransition);
            }
        }
        catch (Exception ex) {
            AppLog.error("Unable to load level settings for " + levelSettingName, ex);
        }
        return levelSettingJson;
    }

    private static TriggerPointConfig getTriggerPointConfig(Json levelSettingJson) {
        String levelSettingName = ObjectUtils.getString(levelSettingJson.get("Name"), "");
        System.out.println("Get Trigger Point Config for " + levelSettingName);
        TriggerPointConfig triggerPointConfig = new TriggerPointConfig(levelSettingName);
        triggerPointConfig.Trigger = ObjectUtils.getString(levelSettingJson.get("Trigger"), "not set");
        String setting = ObjectUtils.getString(levelSettingJson.get("Setting"), "not set");
        System.out.println("setting: " + setting);
        if (!setting.equals("not set")) {
            String[] settings = StringUtils.split(setting, ",");
            triggerPointConfig.Settings = new double[settings.length];
            for (int i = 0; i < settings.length; ++i) {
                triggerPointConfig.Settings[i] = Double.valueOf(settings[i]);
            }
        }
        triggerPointConfig.RelayOutputAction = ObjectUtils.getString(levelSettingJson.get("RelayOutputAction"), "none");
        triggerPointConfig.EndRelayOutputAction = ObjectUtils.getString(levelSettingJson.get("EndRelayOutputAction"), "none");
        String transitionTime = ObjectUtils.getString(levelSettingJson.get("TransitionTime"), "-1");
        if ("".equals(transitionTime)) {
            transitionTime = "-1";
        }
        triggerPointConfig.setTransitionTime(Integer.parseInt(transitionTime));
        return triggerPointConfig;
    }

    private static ThreeChannelLedTransition loadThreeChannel(TriggerPointConfig triggerPointConfig, Json levelSettingJson) {
        String channelString = ObjectUtils.getString(levelSettingJson.get("ThreeChannelLedOutputChannel"), "");
        if (!channelString.equals("") && !channelString.equals("")) {
            String[] channels = StringUtils.split(channelString, ",");
            triggerPointConfig.ThreeChannelDimmerChannels = new int[channels.length];
            for (int i = 0; i < channels.length; ++i) {
                triggerPointConfig.ThreeChannelDimmerChannels[i] = Integer.parseInt(channels[i]);
            }
            ThreeChannelLedTransition threeChannelLed = new ThreeChannelLedTransition(triggerPointConfig);
            return threeChannelLed;
        }
        return null;
    }

    private static FourTwentyTransition loadFourTwentyChannel(TriggerPointConfig triggerPointConfig, Json levelSettingJson) {
        String channelString = ObjectUtils.getString(levelSettingJson.get("FourTwentyOutputChannel"), "");
        System.out.println("FourTwentyTransition channelString = " + channelString);
        if (!channelString.equals("")) {
            String[] channels = StringUtils.split(channelString, ",");
            triggerPointConfig.FourTwentyChannels = new int[channels.length];
            for (int i = 0; i < channels.length; ++i) {
                triggerPointConfig.FourTwentyChannels[i] = Integer.parseInt(channels[i]);
            }
            FourTwentyTransition fourTwentyLevel = new FourTwentyTransition(triggerPointConfig);
            return fourTwentyLevel;
        }
        return null;
    }

    private static TenVoltTransition loadTenVoltChannel(TriggerPointConfig triggerPointConfig, Json levelSettingJson) {
        String channelString = ObjectUtils.getString(levelSettingJson.get("TenVoltOutputChannel"), "");
        if (!channelString.equals("") && !channelString.equals("")) {
            String[] channels = StringUtils.split(channelString, ",");
            triggerPointConfig.TenVoltChannels = new int[channels.length];
            for (int i = 0; i < channels.length; ++i) {
                triggerPointConfig.TenVoltChannels[i] = Integer.parseInt(channels[i]);
            }
            TenVoltTransition tenVoltLevel = new TenVoltTransition(triggerPointConfig);
            return tenVoltLevel;
        }
        return null;
    }

    private static void processConfiguration() {
        ConfiguredLevels = new Hashtable();
        System.out.println("Process Configuration");
        Config.getDefaultGlobalTransitionTime();
        Json[] levelsJson = (Json[])_json.get("LevelSettings");
        System.out.println("Level Settings Json: " + levelsJson);
        for (int i = 0; levelsJson != null && i < levelsJson.length; ++i) {
            levelsJson[i] = Config.loadLevelSettings(levelsJson[i]);
        }
        _json.put("LevelSettings", (Object)levelsJson);
        _json.save(new File("flash/analogpresets.json"));
        System.out.println("config json: " + _json);
    }

    public static int getTcpServerPort() {
        Json clientJson = (Json)_json.get("Client");
        if (clientJson == null) {
            return 9700;
        }
        return ObjectUtils.getInt(clientJson.get("TcpServerPort"), 9700);
    }

    public static byte[] getTerminationBytes() {
        String terminationByteString = Config.getTerminationString();
        return Config.getTerminationBytes(terminationByteString);
    }

    public static String getTerminationString() {
        Json clientJson = (Json)_json.get("Client");
        if (clientJson == null) {
            return "\\r\\n";
        }
        return ObjectUtils.getString(clientJson.get("TerminationString"), "\\r\\n");
    }

    private static byte[] getTerminationBytes(String terminationString) {
        String newTermString = "";
        boolean backslashFound = false;
        for (int i = 0; i < terminationString.length(); ++i) {
            if (terminationString.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
                continue;
            }
            if (backslashFound) {
                switch (terminationString.charAt(i)) {
                    case 'r': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'n': {
                        newTermString = newTermString + '\n';
                        break;
                    }
                    case 't': {
                        newTermString = newTermString + '\r';
                        break;
                    }
                    case 'f': {
                        newTermString = newTermString + '\f';
                        break;
                    }
                    case 'b': {
                        newTermString = newTermString + '\b';
                        break;
                    }
                    case '0': {
                        newTermString = newTermString + '\u0000';
                    }
                }
            } else {
                newTermString = newTermString + terminationString.charAt(i);
            }
            backslashFound = false;
        }
        return newTermString.getBytes();
    }

    static {
        ConfiguredLevels = null;
    }
}

