/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.system.JANOS;

public class RegistryEnumerateModules {
    private String _typeString;
    private String[] _externalDeviceAddressStrings;

    public RegistryEnumerateModules(String typeString) {
        this._typeString = typeString;
    }

    public String[] getExternalDeviceAddressStrings() {
        String[] allExternalDeviceAddressStrings = JANOS.getRegistryList((String)"Externals/DeviceOrder");
        this.printDevicesFromRegistry(allExternalDeviceAddressStrings);
        int typeCount = this.getDeviceTypeCount(allExternalDeviceAddressStrings);
        this._externalDeviceAddressStrings = new String[typeCount];
        int typeIndex = 0;
        for (int i = 0; i < allExternalDeviceAddressStrings.length; ++i) {
            String deviceString = allExternalDeviceAddressStrings[i];
            if (!this.isDeviceType(deviceString)) continue;
            this._externalDeviceAddressStrings[typeIndex++] = deviceString;
        }
        return this._externalDeviceAddressStrings;
    }

    private void printDevicesFromRegistry(String[] externalDeviceAddressStrings) {
        System.out.println("registry device ids: " + externalDeviceAddressStrings.length);
        for (int i = 0; i < externalDeviceAddressStrings.length; ++i) {
            String deviceString = externalDeviceAddressStrings[i];
            String deviceAddress = JANOS.getRegistryString((String)("Externals/DeviceOrder/" + deviceString), (String)"");
            System.out.print("   " + deviceString + " = " + deviceAddress);
            if (this.isDeviceType(deviceString)) {
                System.out.println(" *");
                continue;
            }
            System.out.println("");
        }
    }

    private boolean isDeviceType(String deviceString) {
        return deviceString.indexOf(this._typeString) > 0;
    }

    private int getDeviceTypeCount(String[] externalDeviceAddressStrings) {
        int count = 0;
        for (int i = 0; i < externalDeviceAddressStrings.length; ++i) {
            String deviceString = externalDeviceAddressStrings[i];
            if (deviceString.indexOf(this._typeString) <= 0) continue;
            ++count;
        }
        return count;
    }
}

