/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messaging.websocket;

import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.messaging.websocket.WebsocketClientInformation;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageEventObject;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageHandler;
import com.integpg.janoslib.messaging.websocket.WebsocketServer;
import com.integpg.system.JANOS;
import java.util.Hashtable;
import java.util.Json;

public class RegistryWriteHandler
extends WebsocketMessageHandler {
    public RegistryWriteHandler() {
        super(null);
    }

    @Override
    public String getMessage() {
        return "write-registry";
    }

    @Override
    public void handleMessage(WebsocketMessageEventObject eventObject) throws Exception {
        WebsocketServer websocketServer = eventObject.getWebsocketServer();
        WebsocketClientInformation clientInformation = eventObject.getClientInformation();
        Json json = eventObject.getJson();
        int msgId = eventObject.getMsgId();
        try {
            String key = (String)json.get("Key");
            String value = (String)json.get("Value");
            Hashtable loggedInClients = eventObject.getWebsocketServer().getLoggedInClients();
            if (loggedInClients.containsKey(clientInformation.getClientString())) {
                JANOS.setRegistryString((String)key, (String)value);
                Json jsonResp = new Json("{\"Message\":\"write-registry-resp\"}");
                jsonResp.put("Key", (Object)key);
                jsonResp.put("Value", (Object)JANOS.getRegistryString((String)key, (String)""));
                websocketServer.sendToWebsocket(clientInformation, jsonResp, msgId);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error writing registry", ex);
            Json jsonResp = new Json("{\"Message\":\"Error\",\"Text\":\"" + ex.getMessage() + "\"}");
            websocketServer.sendToWebsocket(clientInformation, jsonResp, msgId);
        }
    }
}

