/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets;

import com.integpg.analogpresets.IClient;
import com.integpg.analogpresets.client.ClientConnectionListener;
import com.integpg.janoslib.io.AppLog;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class UdpServer
implements Runnable,
IClient {
    private final int _port;
    private Thread _thd = null;
    private ClientConnectionListener _listener;
    private String _socketInfo;

    public UdpServer(int port) {
        this._port = port;
    }

    public void setListener(ClientConnectionListener listener) {
        this._listener = listener;
    }

    public void start() {
        if (null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName("UDP Server " + this._port);
            this._thd.start();
        }
    }

    @Override
    public void run() {
        try {
            AppLog.vital("Listening for clients on udp port " + this._port + ".");
            DatagramSocket serverSocket = new DatagramSocket(this._port);
            while (true) {
                byte[] data = new byte[128];
                DatagramPacket packet = new DatagramPacket(data, data.length);
                serverSocket.receive(packet);
                this._socketInfo = String.format("%s:%d (udp port %d)", packet.getAddress().getHostAddress(), packet.getPort(), this._port);
                data = packet.getData();
                String s = new String(data, 0, packet.getLength());
                if (null == this._listener) continue;
                this._listener.processMessage(this, s);
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void send(String s) {
    }

    @Override
    public String getSocketInfo() {
        return this._socketInfo;
    }
}

