/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets;

import com.integ.janoslib.iolog.DigitalInputChannelEvent;
import com.integ.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integ.janoslib.iolog.DigitalOutputChannelEvent;
import com.integ.janoslib.iolog.DigitalOutputsIoLogMonitor;
import com.integ.janoslib.iolog.IoChannelEvent;
import com.integ.janoslib.iolog.IoChannelLogListener;
import com.integpg.analogpresets.AssemblyInfo;
import com.integpg.analogpresets.IClient;
import com.integpg.analogpresets.Jrmon;
import com.integpg.analogpresets.Level;
import com.integpg.analogpresets.TriggerPointConfig;
import com.integpg.analogpresets.UdpServer;
import com.integpg.analogpresets.client.ClientConnection;
import com.integpg.analogpresets.client.ClientConnectionListener;
import com.integpg.analogpresets.configuration.Config;
import com.integpg.analogpresets.websockethandlers.ExecuteLevelHandler;
import com.integpg.analogpresets.websockethandlers.GetConfigHandler;
import com.integpg.analogpresets.websockethandlers.SaveConfigHandler;
import com.integpg.janoslib.externalio.TypeF9;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.messaging.websocket.WebsocketConnectionEventObject;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageEventObject;
import com.integpg.janoslib.messaging.websocket.WebsocketServer;
import com.integpg.janoslib.messaging.websocket.WebsocketServerListener;
import com.integpg.janoslib.net.TcpServer;
import com.integpg.janoslib.net.TcpServerEvent;
import com.integpg.janoslib.net.TcpServerListener;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.DuplicateInstance;
import com.integpg.janoslib.system.MinimumVersion;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;

public class AnalogPresetsMain
implements IoChannelLogListener,
TcpServerListener,
ClientConnectionListener,
WebsocketServerListener {
    public static AnalogPresetsMain INSTANCE;
    public static TypeF9[] _f9Devices;
    public static TypeFD[] _fdDevices;
    public static TypeFE[] _feDevices;
    public static long[] _f9Addresses;
    private WebsocketServer _websocketServer = null;
    private Level _loadedLevel = null;

    public static void main(String[] args) {
        AssemblyInfo assemblyInfo = new AssemblyInfo();
        if (1 == args.length && "--version".equals(args[0])) {
            System.out.println("Name: " + assemblyInfo.getName());
            System.out.println("Version: " + assemblyInfo.getVersion());
            System.out.println("Build Time: " + assemblyInfo.getBuildTime());
            System.exit(0);
        }
        try {
            Application.init(assemblyInfo);
            if (!MinimumVersion.atLeast("dimmer module", "1.0.6")) {
                AppLog.fatal("The OS version does not meet the minimum requirements");
                return;
            }
            if (DuplicateInstance.isDuplicateInstance()) {
                AppLog.fatal("Another instance is already running");
                System.exit(1);
            }
            Application.enableApplicationWatchdog(0);
            INSTANCE = new AnalogPresetsMain();
            INSTANCE.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Unable to init", ex);
            System.exit(-1);
        }
    }

    public void init() throws InterruptedException {
        Config.loadConfiguration();
        this.getConnectedDevices();
        this.setupIOMonitor();
        this.startTcpServer();
        this.startUdpServer();
        this.setupWebsocketServer();
        Application.sleepForever();
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        if (ioEvent instanceof DigitalInputChannelEvent) {
            if (((DigitalInputChannelEvent)ioEvent).State) {
                System.out.println("DIN" + ((DigitalInputChannelEvent)ioEvent).Channel + " has changed");
                this.alertTrigger("DIN" + ((DigitalInputChannelEvent)ioEvent).Channel);
            }
        } else if (ioEvent instanceof DigitalOutputChannelEvent && ((DigitalOutputChannelEvent)ioEvent).State) {
            System.out.println("ROUT" + ((DigitalOutputChannelEvent)ioEvent).Channel + " has changed");
            this.alertTrigger("ROUT" + ((DigitalOutputChannelEvent)ioEvent).Channel);
        }
    }

    private void getConnectedDevices() {
        this.getF9Devices();
        this.getFDDevices();
        this.getFEDevices();
    }

    private void getF9Devices() {
        System.out.println("Get F9 devices");
        _f9Devices = TypeF9.getDeviceArray();
        _f9Addresses = new long[_f9Devices.length];
        AppLog.info("Found " + _f9Devices.length + " LED Dimmer devices");
        for (int i = 0; i < _f9Devices.length; ++i) {
            TypeF9 f9 = _f9Devices[i];
            System.out.println("   " + f9);
            if (null == f9) continue;
            AnalogPresetsMain._f9Addresses[i] = f9.Address;
        }
    }

    private void getFDDevices() {
        System.out.println("Get FD devices");
        _fdDevices = TypeFD.getDeviceArray();
        AppLog.info("Found " + _fdDevices.length + " 10v devices");
        for (int i = 0; i < _fdDevices.length; ++i) {
            TypeFD fd = _fdDevices[i];
            System.out.println("   " + fd);
        }
    }

    private void getFEDevices() {
        System.out.println("Get FE devices");
        _feDevices = TypeFE.getDeviceArray();
        AppLog.info("Found " + _feDevices.length + " 4-20ma devices");
        for (int i = 0; i < _feDevices.length; ++i) {
            TypeFE fe = _feDevices[i];
            System.out.println("   " + fe);
        }
    }

    private void setupIOMonitor() {
        DigitalInputsIoLogMonitor digitalInputsIoLogMonitor = new DigitalInputsIoLogMonitor();
        digitalInputsIoLogMonitor.addIoChannelLogEventListener(this);
        digitalInputsIoLogMonitor.start();
        DigitalOutputsIoLogMonitor digitalOutputsIoLogMonitor = new DigitalOutputsIoLogMonitor();
        digitalOutputsIoLogMonitor.addIoChannelLogEventListener(this);
        digitalOutputsIoLogMonitor.start();
    }

    private void startTcpServer() {
        Config.getTerminationString();
        int tcpServerPort = Config.getTcpServerPort();
        TcpServer tcpServer = new TcpServer("Tcp Server", tcpServerPort);
        tcpServer.setTcpServerListener(this);
        tcpServer.start();
    }

    private void startUdpServer() {
        UdpServer udpServer = new UdpServer(9701);
        udpServer.setListener(this);
        udpServer.start();
    }

    private void setupWebsocketServer() {
        this._websocketServer = new WebsocketServer();
        this._websocketServer.addMessageListener(5004, this);
        this._websocketServer.addMessageHandler(new GetConfigHandler(this));
        this._websocketServer.addMessageHandler(new SaveConfigHandler(this));
        this._websocketServer.addMessageHandler(new ExecuteLevelHandler(this));
    }

    @Override
    public void websocketClientConnected(WebsocketConnectionEventObject eventObject) {
        AppLog.info("WebSocket client connected: " + eventObject.getClientInformation().getClientString());
    }

    @Override
    public void websocketClientDisconnected(WebsocketConnectionEventObject eventObject) {
        AppLog.info("WebSocket client disconnected: " + eventObject.getClientInformation().getClientString());
    }

    @Override
    public void websocketMessageReceived(WebsocketMessageEventObject eventObject) {
        throw new RuntimeException("Please use websocket message handler");
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        Socket socket = evt.getSocket();
        ClientConnection clientConnection = new ClientConnection(socket);
        clientConnection.setListener(this);
        Thread thd = new Thread(clientConnection);
        thd.setDaemon(true);
        thd.start();
    }

    @Override
    public void processMessage(IClient client, String message) {
        block3: {
            try {
                String lowercaseMessage = message.toLowerCase();
                if (!lowercaseMessage.startsWith("trigger")) {
                    AppLog.warn(client + " invalid command: " + message);
                    throw new Exception("Invalid command: " + message);
                }
                this.processTriggerMessage(client, lowercaseMessage);
            }
            catch (Exception ex) {
                AppLog.error("Error processing client message", ex);
                if (null == client) break block3;
                client.send(ex.getMessage());
            }
        }
    }

    private void processTriggerMessage(IClient client, String lowercaseMessage) throws Exception {
        int spacePos = lowercaseMessage.indexOf(" ");
        if (spacePos > 0) {
            String levelName = lowercaseMessage.substring(spacePos);
            levelName = levelName.trim();
            Enumeration e = Config.ConfiguredLevels.keys();
            boolean levelFound = false;
            while (!levelFound && e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!levelName.equalsIgnoreCase(key)) continue;
                Level level = (Level)Config.ConfiguredLevels.get(key);
                this.triggerLevel(level, client.getSocketInfo());
                levelFound = true;
            }
            if (!levelFound) {
                throw new Exception("'" + levelName + "' does not exist");
            }
        } else {
            throw new Exception("Missing space after trigger command");
        }
    }

    private void alertTrigger(String trigger) {
        Enumeration e = Config.ConfiguredLevels.elements();
        while (e.hasMoreElements()) {
            Level level = (Level)e.nextElement();
            TriggerPointConfig triggerPointConfig = level.getTriggerPointConfig();
            if (!triggerPointConfig.Trigger.equalsIgnoreCase(trigger)) continue;
            this.triggerLevel(level, trigger);
        }
    }

    public void triggerLevelByName(String levelName, String callerString) {
        Enumeration e = Config.ConfiguredLevels.elements();
        while (e.hasMoreElements()) {
            Level level = (Level)e.nextElement();
            TriggerPointConfig triggerPointConfig = level.getTriggerPointConfig();
            if (!triggerPointConfig.Name.equalsIgnoreCase(levelName)) continue;
            this.triggerLevel(level, callerString);
            return;
        }
    }

    private void triggerLevel(Level level, String callerString) {
        try {
            TriggerPointConfig triggerPointConfig = level.getTriggerPointConfig();
            Jrmon.parseCommand(triggerPointConfig.RelayOutputAction);
            level.executeTransition(callerString);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

