/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets;

import com.integpg.analogpresets.AnalogPresetsMain;
import com.integpg.analogpresets.ExternalModuleTransition;
import com.integpg.analogpresets.TriggerPointConfig;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.io.AppLog;

public class TenVoltTransition
extends ExternalModuleTransition {
    public TenVoltTransition(TriggerPointConfig triggerPointConfig) {
        super(triggerPointConfig);
    }

    @Override
    protected int getChannelsPerModule() {
        return 2;
    }

    public String toString() {
        return "TenVoltLevel Channel " + this._triggerPointConfig.TenVoltChannels[0] + ":   " + this._triggerPointConfig.toString();
    }

    @Override
    public void executeTransition(String callerString) {
        AppLog.info(callerString + " has triggered a Ten Volt level: " + this._triggerPointConfig.Name);
        Thread thd = new Thread(this);
        thd.setName(this._triggerPointConfig.Name + ":TypeFD");
        thd.setDaemon(true);
        thd.start();
    }

    @Override
    public void run() {
        block10: {
            try {
                int i;
                TypeFD fd = null;
                int lastModuleIndex = -1;
                boolean moduleDirty = false;
                for (i = 0; i < this._triggerPointConfig.TenVoltChannels.length; ++i) {
                    double percent = this._triggerPointConfig.Settings[this._triggerPointConfig.Settings.length != this._triggerPointConfig.TenVoltChannels.length ? 0 : i];
                    int channel = this._triggerPointConfig.TenVoltChannels[i];
                    int moduleIndex = this.getModuleIndex(channel);
                    if (lastModuleIndex == -1) {
                        lastModuleIndex = moduleIndex;
                    }
                    if (moduleIndex != lastModuleIndex) {
                        try {
                            fd.commit();
                            System.out.println("Commit module " + fd.AddressString);
                        }
                        catch (Exception ex) {
                            AppLog.error("Error setting Ten Volt module: " + fd.AddressString, ex);
                        }
                        lastModuleIndex = moduleIndex;
                    }
                    if (null == (fd = AnalogPresetsMain._fdDevices[moduleIndex])) continue;
                    fd.fadeChannelPercentage(this.getChannelIndexOnModule(channel), percent, this._triggerPointConfig.getTransitionTime());
                    moduleDirty = true;
                }
                if (null == fd || !moduleDirty && lastModuleIndex == -1) break block10;
                for (i = 0; i < 3; ++i) {
                    try {
                        fd.commit();
                        System.out.println("Commit module " + fd.AddressString);
                        break;
                    }
                    catch (Exception ex) {
                        AppLog.error("Error setting Ten Volt module: " + fd.AddressString, ex);
                        continue;
                    }
                }
            }
            catch (Exception ex) {
                AppLog.error("Error executing 10v Modules", ex);
            }
        }
    }
}

