/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.MinimumVersion;
import com.integpg.system.JANOS;

public class DuplicateInstance {
    private static final boolean REQUIRED_OS_VERSION = MinimumVersion.atLeast("DuplicateInstance", "1.3-rc2.1");

    public static boolean isDuplicateInstance() {
        if (REQUIRED_OS_VERSION) {
            System.out.println("uuid: " + Application.getAppInstanceName());
            int runningProcesses = JANOS.registerProcess((String)Application.getAppInstanceName());
            DEBUG.println("runningProcesses: " + runningProcesses);
            return 1 < runningProcesses;
        }
        String[] processTable = JANOS.getProcessTable();
        int thisProcessId = JANOS.getProcessID();
        String thisProcessName = JANOS.getProcessName((int)thisProcessId);
        if (thisProcessName.indexOf(47) >= 0) {
            thisProcessName = thisProcessName.substring(thisProcessName.lastIndexOf(47) + 1);
        }
        for (int i = 0; i < processTable.length; ++i) {
            String processLine = processTable[i];
            int colonPos = processLine.indexOf(58);
            String processString = processLine.substring(0, colonPos);
            int processId = Integer.parseInt(processString.trim());
            String processName = processLine.substring(colonPos + 1).trim();
            if (processName.indexOf(47) >= 0) {
                processName = processName.substring(processName.lastIndexOf(47) + 1);
            }
            if (processId == thisProcessId) continue;
            if (processName.equalsIgnoreCase(thisProcessName)) {
                return true;
            }
            if (processName.length() < thisProcessName.length() && thisProcessName.startsWith(processName)) {
                return true;
            }
            if (thisProcessName.length() >= processName.length() || !processName.startsWith(thisProcessName)) continue;
            return true;
        }
        return false;
    }

    public static void exitOnDuplicateInstance() {
        if (DuplicateInstance.isDuplicateInstance()) {
            AppLog.fatal("Another instance of " + Application.getAppInstanceName() + " is already running");
            Application.exit(1);
        }
    }
}

